/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.controllers;

import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.entities.User;
import eu.dnetlib.authentication.services.UserInfoService;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    private final UserInfoService userInfoService;
    private final Properties properties;

    @Autowired
    public UserController(UserInfoService userInfoService, Properties properties) {
        this.userInfoService = userInfoService;
        this.properties = properties;
    }

    @RequestMapping(value={"/userInfo"}, method={RequestMethod.GET})
    public ResponseEntity<User> getUserInfo() {
        return ResponseEntity.ok((Object)this.userInfoService.getUserInfo());
    }

    @RequestMapping(value={"/redirect"}, method={RequestMethod.GET})
    public void redirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String redirect = (String)session.getAttribute("redirect");
        session.removeAttribute("redirect");
        if (redirect == null) {
            redirect = this.properties.getRedirect();
        }
        session.invalidate();
        response.sendRedirect(redirect);
    }
}

