/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.services;

import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.entities.RefreshToken;
import eu.dnetlib.authentication.entities.TokenResponse;
import eu.dnetlib.authentication.entities.User;
import eu.dnetlib.authentication.exception.ResourceNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class UserInfoService {
    private static final Logger logger = LogManager.getLogger(UserInfoService.class);
    RestTemplate restTemplate;
    String issuer;
    RegisteredClient client;
    ServerConfiguration server;

    @Autowired
    public UserInfoService(RestTemplate restTemplate, Properties properties, RegisteredClient client, ServerConfiguration server) {
        this.restTemplate = restTemplate;
        this.issuer = properties.getOidc().getIssuer();
        this.server = server;
        this.client = client;
    }

    public User getUserInfo() throws ResourceNotFoundException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof OIDCAuthenticationToken) {
            return new User((OIDCAuthenticationToken)authentication);
        }
        throw new ResourceNotFoundException("No Session has been found");
    }

    public TokenResponse getAccessToken(String refreshToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity entity = new HttpEntity(this.getTokenRequest(refreshToken), (MultiValueMap)headers);
        return (TokenResponse)this.restTemplate.postForObject(this.server.getTokenEndpointUri(), (Object)entity, TokenResponse.class, new Object[0]);
    }

    public MultiValueMap<String, String> getTokenRequest(String refreshToken) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.client.getClientId());
        map.add((Object)"client_secret", (Object)this.client.getClientSecret());
        map.add((Object)"grant_type", (Object)"refresh_token");
        map.add((Object)"refresh_token", (Object)refreshToken);
        map.add((Object)"scope", (Object)"openid");
        return map;
    }

    public void deleteOldRefreshTokens() {
        OIDCAuthenticationToken authentication = (OIDCAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + authentication.getAccessTokenValue());
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.issuer + "/api/tokens/refresh/", HttpMethod.GET, requestEntity, RefreshToken[].class, new Object[0]);
            List old = Arrays.stream((RefreshToken[])response.getBody()).filter(token -> !token.getValue().equals(authentication.getRefreshTokenValue())).collect(Collectors.toList());
            for (RefreshToken token2 : old) {
                try {
                    ResponseEntity delete = this.restTemplate.exchange(this.issuer + "/api/tokens/refresh/" + token2.getId(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                    if (delete.getStatusCode() == HttpStatus.OK) continue;
                    logger.warn(delete.getStatusCode() + " - Something went wrong for token: " + token2.getId());
                }
                catch (Exception e) {
                    logger.warn("Couldn't delete token: " + token2.getId());
                }
            }
        }
        catch (Exception e) {
            logger.error("Couldn't fetch refresh tokens");
        }
    }
}

