/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.authentication.configuration.GlobalVars;
import eu.dnetlib.authentication.configuration.Properties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableConfigurationProperties(value={Properties.class, GlobalVars.class})
@ComponentScan(basePackages={"eu.dnetlib.authentication"})
public class AuthenticationConfiguration {
    private final Properties properties;
    private final GlobalVars globalVars;

    @Autowired
    public AuthenticationConfiguration(Properties properties, GlobalVars globalVars) {
        this.properties = properties;
        this.globalVars = globalVars;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("authentication.domain", this.properties.getDomain());
        map.put("authentication.keycloak", this.properties.getKeycloak().toString());
        map.put("authentication.redis.host", this.properties.getRedis().getHost());
        map.put("authentication.oidc.issuer", this.properties.getOidc().getIssuer());
        map.put("authentication.oidc.logout", this.properties.getOidc().getLogout());
        map.put("authentication.oidc.home", this.properties.getOidc().getHome());
        map.put("authentication.oidc.redirect", this.properties.getOidc().getRedirect());
        map.put("authentication.oidc.scope", this.properties.getOidc().getScope());
        map.put("authentication.oidc.id", this.properties.getOidc().getId());
        map.put("authentication.oidc.secret", this.properties.getOidc().getSecret());
        map.put("authentication.session", this.properties.getSession());
        map.put("authentication.accessToken", this.properties.getAccessToken());
        map.put("authentication.redirect", this.properties.getRedirect());
        map.put("authentication.authorities-mapper", this.properties.getAuthoritiesMapper());
        if (GlobalVars.date != null) {
            map.put("Date of deploy", GlobalVars.date.toString());
        }
        if (this.globalVars.getBuildDate() != null) {
            map.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            map.put("Version", this.globalVars.getVersion());
        }
        return map;
    }

    @Bean
    RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(new ObjectMapper());
        restTemplate.getMessageConverters().add(converter);
        return restTemplate;
    }

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new WebMvcConfigurerAdapter(){

            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping("/**").allowedMethods(new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS"}).allowCredentials(true);
            }
        };
    }
}

