/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.security;

import eu.dnetlib.authentication.configuration.AuthenticationConfiguration;
import eu.dnetlib.authentication.utils.Redirect;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenAIREAuthenticationFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger(OpenAIREAuthenticationFilter.class);
    private final String domain;

    public OpenAIREAuthenticationFilter(String domain) {
        this.domain = domain;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req;
        String originalUrl;
        if (request instanceof HttpServletRequest && ((originalUrl = (req = (HttpServletRequest)request).getRequestURL().toString()).contains(AuthenticationConfiguration.LOGIN_URL) || originalUrl.contains(AuthenticationConfiguration.LOGOUT_URL))) {
            Redirect.setRedirect(req, this.domain);
        }
        chain.doFilter(request, response);
    }
}

