/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.controllers;

import eu.dnetlib.authentication.configuration.AuthenticationConfiguration;
import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.entities.TokenResponse;
import eu.dnetlib.authentication.entities.User;
import eu.dnetlib.authentication.services.UserInfoService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    private final UserInfoService userInfoService;
    private final Properties properties;

    @Autowired
    public UserController(UserInfoService userInfoService, Properties properties) {
        this.userInfoService = userInfoService;
        this.properties = properties;
    }

    @RequestMapping(value={"/openid_connect_login"}, method={RequestMethod.GET})
    public void login(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(request.getContextPath() + AuthenticationConfiguration.LOGIN_URL + "/" + this.properties.getClient().getName());
    }

    @RequestMapping(value={"/userInfo"}, method={RequestMethod.GET})
    public ResponseEntity<User> getUserInfo(HttpServletRequest request) {
        return ResponseEntity.ok((Object)this.userInfoService.getUserInfo(request));
    }

    @RequestMapping(value={"/accessToken"}, method={RequestMethod.GET})
    @PreAuthorize(value="isAuthenticated() && @SecurityService.hasRefreshToken()")
    public ResponseEntity<TokenResponse> getAccessToken(@RequestParam(name="refreshToken") String refreshToken) {
        return ResponseEntity.ok((Object)this.userInfoService.getAccessToken(refreshToken));
    }

    @RequestMapping(value={"/revoke"}, method={RequestMethod.GET})
    @PreAuthorize(value="isAuthenticated() && @SecurityService.hasRefreshToken()")
    public void revoke(HttpServletRequest request) {
        this.userInfoService.revoke(request);
    }

    @RequestMapping(value={"/redirect"}, method={RequestMethod.GET})
    public void redirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String redirect = (String)session.getAttribute("redirect");
        boolean logout = session.getAttribute("logout") != null ? (Boolean)session.getAttribute("logout") : false;
        session.removeAttribute("redirect");
        session.removeAttribute("logout");
        if (redirect == null) {
            redirect = this.properties.getRedirect();
        }
        if (logout) {
            session.invalidate();
        }
        response.sendRedirect(redirect);
    }
}

