/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.security;

import eu.dnetlib.authentication.configuration.AuthenticationConfiguration;
import eu.dnetlib.authentication.configuration.Client;
import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.services.UserInfoService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class OpenAIRELogoutSuccessHandler
implements LogoutSuccessHandler {
    private final Client client;
    private final UserInfoService service;

    @Autowired
    public OpenAIRELogoutSuccessHandler(Properties properties, UserInfoService service) {
        this.client = properties.getClient();
        this.service = service;
    }

    private String encodeValue(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public String getRedirect(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + (String)(request.getServerPort() != 80 && request.getServerPort() != 443 ? ":" + request.getServerPort() : "") + request.getContextPath() + AuthenticationConfiguration.REDIRECT_URL;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        request.getSession().setAttribute("logout", (Object)true);
        if (this.client.getLogout() != null) {
            response.sendRedirect(this.client.getLogout() + this.encodeValue(this.getRedirect(request)));
        } else {
            response.sendRedirect(this.service.getClient().getProviderDetails().getConfigurationMetadata().get("end_session_endpoint") + "?client_id=" + this.client.getId() + "&post_logout_redirect_uri=" + this.encodeValue(this.getRedirect(request)));
        }
    }
}

