/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.services;

import eu.dnetlib.authentication.security.DefaultAuthoritiesMapper;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.stereotype.Service;

@Service
public class UserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private final OidcUserService delegate = new OidcUserService();
    private final DefaultAuthoritiesMapper mapper;

    @Autowired
    public UserService(@Nullable DefaultAuthoritiesMapper mapper) {
        this.mapper = Objects.requireNonNullElseGet(mapper, DefaultAuthoritiesMapper::new);
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = this.delegate.loadUser(userRequest);
        return new DefaultOidcUser(this.mapper.mapAuthorities(oidcUser), oidcUser.getIdToken(), oidcUser.getUserInfo());
    }
}

