/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.utils;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Redirect {
    private static final Logger logger = LogManager.getLogger(Redirect.class);

    private static String getDomain(String url) throws MalformedURLException {
        return new URL(url).getHost();
    }

    public static void setRedirect(HttpServletRequest request, String domain) {
        HttpSession session = request.getSession();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            if (!param.equalsIgnoreCase("redirect")) continue;
            String redirect = request.getParameter(param);
            try {
                if (!Redirect.getDomain(redirect).endsWith(domain)) continue;
                session.setAttribute("redirect", (Object)redirect);
            }
            catch (MalformedURLException e) {
                logger.error(e.getMessage());
            }
        }
    }
}

