/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.common;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoamonitorservice.common.BaseService;
import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.common.CommonRepository;
import eu.dnetlib.uoamonitorservice.common.Void;
import eu.dnetlib.uoamonitorservice.dto.MoveEntity;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.handlers.BadRequestException;
import eu.dnetlib.uoamonitorservice.handlers.PathNotValidException;
import eu.dnetlib.uoamonitorservice.utils.GenericAccessor;
import eu.dnetlib.uoamonitorservice.utils.ReflectionUtils;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.core.ResolvableType;

public abstract class CommonService<Entity extends Common, EntityFull extends Common, Parent extends Void>
extends BaseService {
    protected final CommonRepository<Entity, Parent> repository;
    protected final Class<Entity> entityClass;
    protected final Class<EntityFull> entityFullClass;
    protected final Class<Parent> parentClass;
    protected CommonService<? extends Common, ? extends Common, Entity> childService;

    protected CommonService(AuthorizationService authorizationService, CommonRepository<Entity, Parent> repository) {
        super(authorizationService);
        this.repository = repository;
        ResolvableType type = ResolvableType.forClass(this.getClass()).as(CommonService.class);
        this.entityClass = type.getGeneric(new int[]{0}).resolve();
        this.entityFullClass = type.getGeneric(new int[]{1}).resolve();
        this.parentClass = type.getGeneric(new int[]{2}).resolve();
    }

    public Entity override(@NotNull Stakeholder stakeholder, Entity entity) {
        if (stakeholder.isReference()) {
            if (entity.getClass() == Stakeholder.class) {
                stakeholder.getChildrenFields().forEach(field -> ReflectionUtils.setField((Object)entity, (String)field, (Object)ReflectionUtils.getField((Object)this.repository.findById(stakeholder.getDefaultId()), (String)field)));
            }
            entity.override(stakeholder);
        }
        return entity;
    }

    public Entity find(String id) {
        return (Entity)this.repository.findById(id);
    }

    public Entity find(Stakeholder stakeholder, String id) {
        if (stakeholder != null) {
            return (Entity)this.override(stakeholder, this.find(id));
        }
        return (Entity)this.find(id);
    }

    public Entity findByPath(Stakeholder stakeholder, Parent parent, String id) {
        Common entity;
        if (parent instanceof Common && (entity = (Common)parent).getChildrenFields().stream().noneMatch(field -> entity.getChildren(field).contains(id))) {
            throw new PathNotValidException(this.entityClass.getName() + " with id: " + id + " not found in " + entity.getClass().getName() + ": " + entity.getId());
        }
        return (Entity)this.find(stakeholder, id);
    }

    protected EntityFull getFull(Stakeholder stakeholder, Entity entity) {
        if (this.hasVisibilityAuthority(stakeholder, entity = this.override(stakeholder, entity))) {
            Object[] childArgs = this.childService != null ? entity.getChildrenFields().stream().map(arg_0 -> entity.getChildren(arg_0)).map(ids -> ids.stream().map(id -> this.childService.getFull(stakeholder, (String)id)).filter(Objects::nonNull).collect(Collectors.toList())).toArray() : new Object[]{};
            Object[] constructorArgs = new Object[childArgs.length + 1];
            constructorArgs[0] = entity;
            System.arraycopy(childArgs, 0, constructorArgs, 1, childArgs.length);
            return (EntityFull)((Common)ReflectionUtils.createInstanceWithArgs((Class)this.entityFullClass, (Object[])constructorArgs));
        }
        return null;
    }

    public EntityFull getFull(Stakeholder stakeholder, String id) {
        Common entity = this.find(stakeholder, id);
        return (EntityFull)this.getFull(stakeholder, entity);
    }

    public String copy(String stakeholderId, String id) {
        Common entity = this.find(id);
        Common copy = (Common)ReflectionUtils.createInstanceWithArgs((Class)this.entityClass, (Object[])new Object[]{entity});
        copy.setId(null);
        copy.setParentId(stakeholderId);
        if (this.childService != null) {
            entity.getChildrenFields().forEach(field -> ReflectionUtils.setField((Object)copy, (String)field, entity.getChildren(field).stream().map(child -> this.childService.copy(stakeholderId, (String)child)).toList()));
        }
        return this.save(copy).getId();
    }

    public Entity secure(Stakeholder stakeholder, Entity entity) {
        if (entity.getId() != null) {
            Common old = this.find(entity.getId());
            old.override(stakeholder);
            GenericAccessor.getUnmodifiableFields((Class)this.entityClass).forEach(field -> ReflectionUtils.setField((Object)entity, (String)field, (Object)ReflectionUtils.getField((Object)old, (String)field)));
        }
        return entity;
    }

    public Entity save(@NotNull Entity entity) {
        return (Entity)this.repository.save(entity);
    }

    public EntityFull save(Stakeholder stakeholder, @NotNull Entity entity, Parent parent, String childrenField, Integer index) {
        if (entity.getId() != null) {
            if (this.hasEditAuthority(stakeholder)) {
                if ((entity = this.secure(stakeholder, entity)).isOwnedBy(stakeholder)) {
                    entity = this.save(entity);
                } else {
                    this.repository.save(stakeholder, entity);
                }
            } else {
                this.unauthorized("You are not authorized to update " + this.entityClass.getName() + " with id: " + entity.getId());
            }
        } else if (this.hasCreateAuthority(stakeholder)) {
            entity.setParentId(stakeholder.getId());
            entity = this.save(entity);
            stakeholder = this.repository.addChild(stakeholder, entity.getId(), parent, childrenField, index);
        } else {
            this.unauthorized("You are not authorized to create a " + this.entityClass.getName() + " in stakeholder with id: " + stakeholder.getId());
        }
        return (EntityFull)this.getFull(stakeholder, entity.getId());
    }

    public EntityFull saveFull(Stakeholder stakeholder, Common entityFull, Parent parent, String childrenField) {
        return (EntityFull)this.saveFull(stakeholder, entityFull, parent, childrenField, null);
    }

    public EntityFull saveFull(Stakeholder stakeholder, Common entityFull, Parent parent, String childrenField, Integer index) {
        if (entityFull.getClass().equals(this.entityFullClass)) {
            HashMap children = new HashMap();
            entityFull.getChildrenFields().forEach(field -> children.put(field, new ArrayList(entityFull.getChildren(field))));
            Common savedFull = this.save(stakeholder, (Common)ReflectionUtils.createInstanceWithArgs((Class)this.entityClass, (Object[])new Object[]{entityFull}), parent, childrenField, index);
            savedFull.getChildrenFields().forEach(field -> savedFull.getChildren(field).forEach(child -> {
                if (((List)children.get(field)).stream().noneMatch(c -> Objects.equals(ReflectionUtils.getField((Object)child, (String)"id"), ReflectionUtils.getField((Object)c, (String)"id")))) {
                    this.childService.delete(this.repository.getStakeholder(stakeholder.getId()), (String)ReflectionUtils.getField((Object)child, (String)"id"));
                }
            }));
            Common entity = (Common)ReflectionUtils.createInstanceWithArgs((Class)this.entityClass, (Object[])new Object[]{savedFull});
            GenericAccessor.getChildrenFields((Class)this.entityClass).forEach(field -> {
                List childrenByField = (List)children.get(field);
                ReflectionUtils.setField((Object)entity, (String)field, IntStream.range(0, childrenByField.size()).mapToObj(i -> this.childService.saveFull(this.repository.getStakeholder(stakeholder.getId()), (Common)childrenByField.get(i), (Void)((Common)ReflectionUtils.createInstanceWithArgs((Class)this.entityClass, (Object[])new Object[]{savedFull})), field, Integer.valueOf(i)).getId()).collect(Collectors.toList()));
            });
            Common saved = this.repository.save(this.repository.getStakeholder(stakeholder.getId()), entity);
            return (EntityFull)this.getFull(this.repository.getStakeholder(stakeholder.getId()), saved);
        }
        throw new BadRequestException("Unsupported entity class: " + entityFull.getClass().getName());
    }

    public Stakeholder reorder(Stakeholder stakeholder, Parent parent, String children, List<String> ids) {
        Common p;
        if (parent instanceof Common) {
            p = (Common)parent;
            if (this.hasEditAuthority(stakeholder)) {
                ids.forEach(id -> this.find(stakeholder, id));
                List saved = p.getChildren(children);
                if (saved != null && saved.size() == ids.size() && new HashSet(saved).containsAll(ids)) {
                    return this.repository.reorder(stakeholder, parent, children, ids);
                }
                throw new NotFoundException("Some " + children + " dont exist in the " + this.parentClass.getName() + " with id " + p.getId());
            }
        } else {
            throw new BadRequestException("Cannot perform a reorder if parent doesn't exist");
        }
        this.unauthorized("You are not authorized to update " + this.parentClass.getName() + " with id: " + p.getId());
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Stakeholder move(Stakeholder stakeholder, Parent parent, MoveEntity moveEntity, String children) {
        if (!(parent instanceof Common)) throw new BadRequestException("Cannot perform a reorder if parent doesn't exist");
        Common p = (Common)parent;
        if (this.childService == null) throw new BadRequestException("Cannot perform a reorder if parent doesn't exist");
        if (this.hasEditAuthority(stakeholder)) {
            Common from = this.findByPath(stakeholder, parent, moveEntity.getFrom().getId());
            Common to = this.findByPath(stakeholder, parent, moveEntity.getTo().getId());
            from.removeChild(children, moveEntity.getTarget());
            to.addChild(children, moveEntity.getTarget());
            stakeholder = this.childService.reorder(stakeholder, (Void)this.repository.save(stakeholder, from), children, moveEntity.getFrom().getChildren());
            return this.childService.reorder(stakeholder, (Void)this.repository.save(stakeholder, to), children, moveEntity.getTo().getChildren());
        }
        this.unauthorized("You are not authorized to update " + this.parentClass.getName() + " with id: " + p.getId());
        return stakeholder;
    }

    protected void delete(Stakeholder stakeholder, Entity entity) {
        if (this.hasDeleteAuthority(stakeholder)) {
            if (this.childService != null) {
                entity.getChildrenFields().forEach(field -> entity.getChildren(field).forEach(id -> this.childService.delete(stakeholder, (String)id)));
            }
            this.repository.delete(stakeholder, entity);
        } else {
            this.unauthorized("Delete " + this.entityClass.getName() + " You are not authorized to delete " + this.entityClass.getName() + " with id: " + entity.getId());
        }
    }

    public void delete(Stakeholder stakeholder, String id) {
        Common entity = this.find(stakeholder, id);
        this.delete(stakeholder, entity);
    }

    public EntityFull changeVisibility(Stakeholder stakeholder, Common entity, String visibility, Boolean propagate) {
        if (this.hasEditAuthority(stakeholder)) {
            entity.setVisibility(visibility);
            if (propagate.booleanValue() && this.childService != null) {
                entity.getChildrenFields().forEach(field -> entity.getChildren(field).forEach(id -> this.childService.changeVisibility(stakeholder, this.childService.find((String)id), visibility, Boolean.valueOf(true))));
            }
            return (EntityFull)this.save(stakeholder, entity, null, null, null);
        }
        this.unauthorized("Change " + this.entityClass.getName() + "'s  visibility: You are not authorized to update " + this.entityClass.getName() + " with id: " + entity.getId());
        return null;
    }

    public EntityFull restoreDefault(Stakeholder stakeholder, Entity entity) {
        Common entityFull = this.getFull(stakeholder, entity.getId());
        if (this.hasEditAuthority(stakeholder)) {
            if (entityFull.isRestorable()) {
                if (this.childService != null) {
                    List restorableFields = GenericAccessor.getRestorableFields((Class)this.entityClass);
                    entity.getChildrenFields().stream().filter(restorableFields::contains).forEach(field -> entity.getChildren(field).forEach(id -> this.childService.delete(stakeholder, (String)id)));
                }
                this.repository.deleteOverride(stakeholder, entity);
            }
        } else {
            this.unauthorized("Change " + this.entityClass.getName() + " to default: You are not authorized to update " + this.entityClass.getName() + " with id: " + entity.getId());
        }
        return (EntityFull)this.getFull(this.repository.getStakeholder(stakeholder.getId()), entity.getId());
    }
}

