/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.dao;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoamonitorservice.common.CommonRepository;
import eu.dnetlib.uoamonitorservice.common.Void;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.primitives.StakeholderType;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class StakeholderRepository
extends CommonRepository<Stakeholder, Void> {
    private static final Criteria NOT_DEFAULT = Criteria.where((String)"defaultId").exists(true).ne(null);
    private static final Criteria DEFAULT = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"defaultId").exists(false), Criteria.where((String)"defaultId").isNull()});
    private static final Criteria UMBRELLA = Criteria.where((String)"umbrella").exists(true).ne(null);
    private static final Criteria NOT_UMBRELLA = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"umbrella").exists(false), Criteria.where((String)"umbrella").isNull()});
    private static final Criteria STANDALONE = Criteria.where((String)"standalone").is((Object)true);
    private static final Criteria NOT_STANDALONE = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"standalone").exists(false), Criteria.where((String)"standalone").isNull(), Criteria.where((String)"standalone").ne((Object)true)});

    @Autowired
    public StakeholderRepository(MongoTemplate mongoTemplate) {
        super(mongoTemplate);
    }

    public Stakeholder findByAlias(String alias) {
        return this.findByAlias(alias, true);
    }

    public Stakeholder findByAlias(String alias, boolean trowException) {
        Stakeholder stakeholder = (Stakeholder)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"alias").is((Object)alias)), Stakeholder.class);
        if (stakeholder == null && trowException) {
            throw new NotFoundException("Stakeholder with alias: " + alias + " not found");
        }
        return stakeholder;
    }

    public List<Stakeholder> findByDefaultId(String defaultId) {
        return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"defaultId").is((Object)defaultId)), Stakeholder.class);
    }

    public List<Stakeholder> getOtherParents(String parent, StakeholderType type, String id) {
        return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"alias").ne((Object)parent).and("umbrella.children." + String.valueOf(type)).regex(id, "i")), Stakeholder.class);
    }

    public Stakeholder getActiveParent(String parent, StakeholderType type, String id) {
        Stakeholder stakeholder = (Stakeholder)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"alias").is((Object)parent).and("umbrella.children." + String.valueOf(type)).regex(id, "i")), Stakeholder.class);
        if (stakeholder == null) {
            throw new NotFoundException("Stakeholder with alias: " + parent + " not found");
        }
        return stakeholder;
    }

    public List<Stakeholder> allStakeholders(String type) {
        return this.findAll(Optional.ofNullable(StakeholderType.fromLabel((String)type)));
    }

    private List<Stakeholder> findAll(Optional<StakeholderType> type) {
        Criteria criteria = new Criteria();
        type.ifPresent(stakeholderType -> criteria.and("type").is(stakeholderType));
        Query query = new Query((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, Stakeholder.class);
    }

    public List<Stakeholder> defaultStakeholders(String type) {
        return this.findDefaultStakeholders(Optional.ofNullable(StakeholderType.fromLabel((String)type)));
    }

    private List<Stakeholder> findDefaultStakeholders(Optional<StakeholderType> type) {
        Criteria criteria = new Criteria().andOperator(new Criteria[]{DEFAULT});
        type.ifPresent(stakeholderType -> criteria.and("type").is(stakeholderType));
        Query query = new Query((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}));
        return this.mongoTemplate.find(query, Stakeholder.class);
    }

    public List<Stakeholder> standaloneStakeholders(String type) {
        return this.findStandaloneStakeholders(Optional.ofNullable(StakeholderType.fromLabel((String)type)));
    }

    private List<Stakeholder> findStandaloneStakeholders(Optional<StakeholderType> type) {
        Criteria criteria = new Criteria().andOperator(new Criteria[]{NOT_DEFAULT, NOT_UMBRELLA, STANDALONE});
        type.ifPresent(stakeholderType -> criteria.and("type").is(stakeholderType));
        Query query = new Query((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}));
        return this.mongoTemplate.find(query, Stakeholder.class);
    }

    public List<Stakeholder> umbrellaStakeholders(String type) {
        return this.findUmbrellaStakeholders(Optional.ofNullable(StakeholderType.fromLabel((String)type)));
    }

    private List<Stakeholder> findUmbrellaStakeholders(Optional<StakeholderType> type) {
        Criteria criteria = new Criteria().andOperator(new Criteria[]{NOT_DEFAULT, UMBRELLA, STANDALONE});
        type.ifPresent(stakeholderType -> criteria.and("type").is(stakeholderType));
        Query query = new Query((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}));
        return this.mongoTemplate.find(query, Stakeholder.class);
    }

    public List<Stakeholder> dependentStakeholders(String type) {
        return this.findDependentStakeholders(Optional.ofNullable(StakeholderType.fromLabel((String)type)));
    }

    private List<Stakeholder> findDependentStakeholders(Optional<StakeholderType> type) {
        Criteria criteria = new Criteria().andOperator(new Criteria[]{NOT_DEFAULT, NOT_UMBRELLA, NOT_STANDALONE});
        type.ifPresent(stakeholderType -> criteria.and("type").is(stakeholderType));
        Query query = new Query((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}));
        return this.mongoTemplate.find(query, Stakeholder.class);
    }

    public List<Stakeholder> browseStakeholders(String type, String defaultId) {
        return this.findBrowseStakeholders(Optional.ofNullable(StakeholderType.fromLabel((String)type)), Optional.ofNullable(defaultId));
    }

    private List<Stakeholder> findBrowseStakeholders(Optional<StakeholderType> type, Optional<String> defaultId) {
        Criteria criteria = new Criteria().andOperator(new Criteria[]{NOT_DEFAULT, STANDALONE});
        type.ifPresent(stakeholderType -> criteria.and("type").is(stakeholderType));
        defaultId.ifPresent(id -> criteria.and("defaultId").is(id));
        Query query = new Query((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}));
        return this.mongoTemplate.find(query, Stakeholder.class);
    }
}

