/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoamonitorservice.dto.IndicatorFull;
import eu.dnetlib.uoamonitorservice.dto.SectionFull;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Indicator;
import eu.dnetlib.uoamonitorservice.entities.Section;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.SubCategory;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.service.CategoryService;
import eu.dnetlib.uoamonitorservice.service.IndicatorService;
import eu.dnetlib.uoamonitorservice.service.SectionService;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import eu.dnetlib.uoamonitorservice.service.SubCategoryService;
import eu.dnetlib.uoamonitorservice.service.TopicService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IndicatorController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final StakeholderService stakeholderService;
    private final TopicService topicService;
    private final CategoryService categoryService;
    private final SubCategoryService subCategoryService;
    private final SectionService sectionService;
    private final IndicatorService indicatorService;

    @Autowired
    public IndicatorController(StakeholderService stakeholderService, TopicService topicService, CategoryService categoryService, SubCategoryService subCategoryService, SectionService sectionService, IndicatorService indicatorService) {
        this.stakeholderService = stakeholderService;
        this.topicService = topicService;
        this.categoryService = categoryService;
        this.subCategoryService = subCategoryService;
        this.sectionService = sectionService;
        this.indicatorService = indicatorService;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/save"}, method={RequestMethod.POST})
    public ResponseEntity<IndicatorFull> saveIndicator(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @RequestBody IndicatorFull indicator) {
        this.log.debug("save indicator");
        this.log.debug("Name: " + indicator.getName() + " - Id: " + indicator.getId() + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        SubCategory subCategory = (SubCategory)this.subCategoryService.findByPath(stakeholder, category, subcategoryId);
        Section section = (Section)this.sectionService.findByPath(stakeholder, subCategory, sectionId);
        if (indicator.getId() != null) {
            this.indicatorService.findByPath(stakeholder, section, indicator.getId());
        }
        return ResponseEntity.ok((Object)this.indicatorService.saveFull(stakeholder, section, indicator));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/{indicatorId}/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<Boolean> deleteIndicator(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @PathVariable(value="indicatorId") String indicatorId) {
        this.log.debug("delete indicator");
        this.log.debug("Id: " + indicatorId + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        SubCategory subCategory = (SubCategory)this.subCategoryService.findByPath(stakeholder, category, subcategoryId);
        Section section = (Section)this.sectionService.findByPath(stakeholder, subCategory, sectionId);
        Indicator indicator = (Indicator)this.indicatorService.findByPath(stakeholder, section, indicatorId);
        this.indicatorService.delete(stakeholder, indicator.getId());
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/reorder"}, method={RequestMethod.POST})
    public ResponseEntity<List<IndicatorFull>> reorderIndicators(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @RequestBody List<String> indicators) {
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        SubCategory subCategory = (SubCategory)this.subCategoryService.findByPath(stakeholder, category, subcategoryId);
        Section section = (Section)this.sectionService.findByPath(stakeholder, subCategory, sectionId);
        return ResponseEntity.ok(((SectionFull)this.sectionService.getFull(this.indicatorService.reorder(stakeholder, section, indicators), sectionId)).getIndicators());
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/{indicatorId}/change-visibility"}, method={RequestMethod.POST})
    public ResponseEntity<IndicatorFull> changeIndicatorVisibility(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @PathVariable(value="indicatorId") String indicatorId, @RequestParam(value="visibility") String visibility) {
        this.log.debug("change indicator visibility: " + visibility);
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId + " - Indicator: " + indicatorId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        SubCategory subCategory = (SubCategory)this.subCategoryService.findByPath(stakeholder, category, subcategoryId);
        Section section = (Section)this.sectionService.findByPath(stakeholder, subCategory, sectionId);
        Indicator indicator = (Indicator)this.indicatorService.findByPath(stakeholder, section, indicatorId);
        return ResponseEntity.ok((Object)this.indicatorService.changeVisibility(stakeholder, indicator, visibility));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/{indicatorId}/reset"}, method={RequestMethod.POST})
    public ResponseEntity<IndicatorFull> reset(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @PathVariable(value="indicatorId") String indicatorId) {
        this.log.debug("restore to default topic");
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        SubCategory subCategory = (SubCategory)this.subCategoryService.findByPath(stakeholder, category, subcategoryId);
        Section section = (Section)this.sectionService.findByPath(stakeholder, subCategory, sectionId);
        Indicator indicator = (Indicator)this.indicatorService.findByPath(stakeholder, section, indicatorId);
        return ResponseEntity.ok((Object)((IndicatorFull)this.indicatorService.restoreDefault(stakeholder, indicator)));
    }
}

