/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.utils;

import eu.dnetlib.uoamonitorservice.annotations.Overridable;
import eu.dnetlib.uoamonitorservice.handlers.BadRequestException;
import eu.dnetlib.uoamonitorservice.utils.GenericAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectionUtils {
    private static final String DOT = ".";
    private static final String DOT_REPLACEMENT = "_dot_";

    public static <T> T createInstanceWithArgs(Class<T> clazz, Object ... args) {
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (!ReflectionUtils.areArgumentsCompatible(parameterTypes, args)) continue;
                constructor.setAccessible(true);
                return (T)constructor.newInstance(args);
            }
            throw new BadRequestException("No compatible constructor found for " + clazz.getName());
        }
        catch (Exception e) {
            throw new BadRequestException("Failed to create an instance of " + clazz.getName());
        }
    }

    private static boolean areArgumentsCompatible(Class<?>[] parameterTypes, Object[] args) {
        if (parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (args[i] == null || parameterTypes[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> void setField(Object obj, String fieldName, T value) {
        if (fieldName == null || fieldName.equals("className")) {
            return;
        }
        try {
            String[] fieldParts = fieldName.replace(DOT_REPLACEMENT, DOT).split("\\.");
            Object targetObject = obj;
            for (int i = 0; i < fieldParts.length - 1; ++i) {
                String currentFieldName = fieldParts[i];
                if (targetObject instanceof Map) {
                    targetObject = ((Map)targetObject).get(currentFieldName);
                } else {
                    Field field = ReflectionUtils.findField(targetObject.getClass(), currentFieldName);
                    field.setAccessible(true);
                    targetObject = field.get(targetObject);
                }
                if (targetObject != null) continue;
                throw new BadRequestException("Intermediate field '" + currentFieldName + "' is null");
            }
            String finalFieldName = fieldParts[fieldParts.length - 1];
            if (targetObject instanceof Map) {
                ((Map)targetObject).put(finalFieldName, value);
                return;
            } else {
                Field finalField = ReflectionUtils.findField(targetObject.getClass(), finalFieldName);
                finalField.setAccessible(true);
                if (finalField.getType().isEnum()) {
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        Enum<?> enumValue = ReflectionUtils.getEnumValue(finalField.getType(), stringValue);
                        finalField.set(targetObject, enumValue);
                        return;
                    } else {
                        if (!finalField.getType().isAssignableFrom(value.getClass())) throw new BadRequestException("Incompatible types: cannot assign " + value.getClass().getName() + " to " + finalField.getType().getName());
                        finalField.set(targetObject, value);
                    }
                    return;
                } else {
                    finalField.set(targetObject, value);
                }
            }
            return;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new BadRequestException("Error setting field " + fieldName);
        }
    }

    public static Object getField(Object obj, String fieldName) {
        try {
            String[] fieldParts;
            for (String part : fieldParts = fieldName.replace(DOT_REPLACEMENT, DOT).split("\\.")) {
                Field field = ReflectionUtils.findField(obj.getClass(), part);
                field.setAccessible(true);
                obj = field.get(obj);
                if (obj != null) continue;
                return null;
            }
            return obj;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new BadRequestException("Error getting field: " + e.getMessage());
        }
    }

    public static Map<String, Object> getOverrides(Object original, Object updated, Set<String> fields) {
        if (original == null || updated == null) {
            throw new IllegalArgumentException("Objects cannot be null");
        }
        if (!original.getClass().equals(updated.getClass())) {
            throw new IllegalArgumentException("Objects must be of the same class");
        }
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        Class<?> clazz = original.getClass();
        for (Field field : GenericAccessor.getOverridableFields(clazz)) {
            field.setAccessible(true);
            try {
                Object originalValue = field.get(original);
                Object updatedValue = field.get(updated);
                if (originalValue instanceof Map) {
                    Map originalMap = (Map)originalValue;
                    if (updatedValue instanceof Map) {
                        Map updatedMap = (Map)updatedValue;
                        ReflectionUtils.processMapOverrides(field.getName(), originalMap, updatedMap, overrides, fields);
                        continue;
                    }
                }
                if (originalValue instanceof List) {
                    List originalList = (List)originalValue;
                    if (updatedValue instanceof List) {
                        List updatedList = (List)updatedValue;
                        if (ReflectionUtils.compareLists(originalList, updatedList) && !fields.contains(field.getName())) continue;
                        overrides.put(field.getName(), updatedValue);
                        continue;
                    }
                }
                if (!(originalValue == null && updatedValue != null || originalValue != null && !originalValue.equals(updatedValue)) && !fields.contains(field.getName())) continue;
                overrides.put(field.getName(), updatedValue);
            }
            catch (IllegalAccessException e) {
                throw new BadRequestException("Error accessing field: " + field.getName());
            }
        }
        return overrides;
    }

    private static Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (clazz != null) {
            throw new NoSuchFieldException("Field '" + fieldName + "' not found in class hierarchy of " + clazz.getName());
        }
        throw new NoSuchFieldException("Field '" + fieldName + "' not found in class hierarchy");
    }

    private static Enum<?> getEnumValue(Class<?> enumType, String value) {
        for (Object constant : enumType.getEnumConstants()) {
            if (!constant.toString().equals(value)) continue;
            return (Enum)constant;
        }
        throw new IllegalArgumentException("No enum constant '" + value + "' in enum " + enumType.getName());
    }

    private static void processMapOverrides(String fieldName, Map<?, ?> originalMap, Map<?, ?> updatedMap, Map<String, Object> overrides, Set<String> fields) {
        for (Map.Entry<?, ?> entry : updatedMap.entrySet()) {
            Object key = entry.getKey();
            Object updatedValue = entry.getValue();
            Object originalValue = originalMap.get(key);
            if (updatedValue != null && updatedValue.getClass().isAnnotationPresent(Overridable.class)) {
                Map<String, Object> nestedOverrides = ReflectionUtils.getOverrides(originalValue, updatedValue, fields);
                nestedOverrides.forEach((nestedKey, value) -> overrides.put(fieldName + DOT_REPLACEMENT + String.valueOf(key) + DOT_REPLACEMENT + nestedKey, value));
                continue;
            }
            if (!(originalValue == null && updatedValue != null || originalValue != null && !originalValue.equals(updatedValue)) && !fields.contains(fieldName)) continue;
            overrides.put(fieldName + DOT_REPLACEMENT + String.valueOf(key), updatedValue);
        }
    }

    private static boolean compareLists(List<?> originalList, List<?> updatedList) {
        if (originalList == null || updatedList == null) {
            return originalList == updatedList;
        }
        if (originalList.size() != updatedList.size()) {
            return false;
        }
        for (int i = 0; i < originalList.size(); ++i) {
            Object originalElement = originalList.get(i);
            Object updatedElement = updatedList.get(i);
            if ((originalElement != null || updatedElement == null) && (originalElement == null || originalElement.equals(updatedElement))) continue;
            return false;
        }
        return true;
    }
}

