/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.primitives;

import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.primitives.StakeholderType;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Umbrella<T> {
    List<StakeholderType> types;
    Map<StakeholderType, List<T>> children;

    public Umbrella() {
        this.types = new ArrayList<StakeholderType>();
        this.children = new HashMap<StakeholderType, List<T>>();
    }

    public Umbrella(List<String> types) {
        this.setTypes(types);
        this.children = new HashMap<StakeholderType, List<T>>();
    }

    public static Umbrella<String> convert(Umbrella<Stakeholder> umbrellaFull) {
        if (umbrellaFull == null) {
            return null;
        }
        Umbrella<String> umbrella = new Umbrella<String>(umbrellaFull.getTypes());
        umbrella.getTypes().forEach(type -> umbrella.children.put(StakeholderType.fromLabel(type), umbrellaFull.getChildren().get(type).stream().map(Common::getId).collect(Collectors.toList())));
        return umbrella;
    }

    public static Umbrella<Stakeholder> convert(Umbrella<String> umbrella, StakeholderService service) {
        if (umbrella == null) {
            return null;
        }
        Umbrella<Stakeholder> umbrellaFull = new Umbrella<Stakeholder>(umbrella.getTypes());
        umbrella.getTypes().forEach(type -> umbrellaFull.children.put(StakeholderType.fromLabel(type), umbrella.getChildren().get(type).stream().map(service::findByPath).collect(Collectors.toList())));
        return umbrellaFull;
    }

    public Map<String, List<T>> getChildren() {
        return this.children.entrySet().stream().collect(Collectors.toMap(e -> ((StakeholderType)e.getKey()).getLabel(), Map.Entry::getValue));
    }

    public void setChildren(Map<String, List<T>> children) {
        this.children = children.entrySet().stream().collect(Collectors.toMap(e -> StakeholderType.fromLabel((String)e.getKey()), Map.Entry::getValue));
    }

    public List<String> getTypes() {
        return this.types.stream().map(StakeholderType::getLabel).toList();
    }

    public void setTypes(List<String> types) {
        this.types = types.stream().map(StakeholderType::fromLabel).toList();
    }

    public boolean addType(String type) {
        StakeholderType stakeholderType = StakeholderType.fromLabel(type);
        if (!this.getTypes().contains(type)) {
            this.types.add(stakeholderType);
            this.children.put(stakeholderType, new ArrayList());
        }
        return true;
    }

    public boolean removeType(String type) {
        StakeholderType stakeholderType = StakeholderType.fromLabel(type);
        if (this.getTypes().contains(type)) {
            this.types.remove(stakeholderType);
            this.children.remove(stakeholderType);
        }
        return true;
    }

    public boolean addChild(String type, T child) {
        StakeholderType stakeholderType = StakeholderType.fromLabel(type);
        if (this.getTypes().contains(type)) {
            if (!this.children.containsKey(stakeholderType)) {
                this.children.put(stakeholderType, new ArrayList());
            }
            if (!this.children.get(stakeholderType).contains(child)) {
                return this.children.get(stakeholderType).add(child);
            }
        }
        return false;
    }

    public boolean removeChild(String type, T child) {
        StakeholderType stakeholderType = StakeholderType.fromLabel(type);
        if (this.types.contains(stakeholderType)) {
            if (!this.children.containsKey(stakeholderType)) {
                return false;
            }
            if (this.children.get(stakeholderType).contains(child)) {
                return this.children.get(stakeholderType).remove(child);
            }
        }
        return false;
    }

    public boolean update(List<String> types) {
        if (types == null) {
            return false;
        }
        if (types.size() != this.types.size()) {
            return false;
        }
        if (new HashSet<String>(this.getTypes()).containsAll(types)) {
            this.setTypes(types);
            return true;
        }
        return false;
    }

    public boolean update(String type, List<T> children) {
        StakeholderType stakeholderType = StakeholderType.fromLabel(type);
        if (children == null) {
            return false;
        }
        if (this.children.get(stakeholderType) == null) {
            return false;
        }
        if (children.size() != this.children.get(stakeholderType).size()) {
            return false;
        }
        return new HashSet(this.children.get(stakeholderType)).containsAll(children);
    }
}

