/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.dto.BuildStakeholder;
import eu.dnetlib.uoamonitorservice.dto.ManageStakeholders;
import eu.dnetlib.uoamonitorservice.dto.StakeholderFull;
import eu.dnetlib.uoamonitorservice.dto.StakeholderOptions;
import eu.dnetlib.uoamonitorservice.dto.UpdateUmbrella;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.generics.StakeholderGeneric;
import eu.dnetlib.uoamonitorservice.primitives.Umbrella;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StakeholderController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final PortalService portalService;
    private final StakeholderService stakeholderService;

    @Autowired
    public StakeholderController(PortalService portalService, StakeholderService stakeholderService) {
        this.portalService = portalService;
        this.stakeholderService = stakeholderService;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/stakeholder/alias"}, method={RequestMethod.GET})
    public ResponseEntity<List<String>> getAllReservedStakeholderAlias(@RequestParam(required=false, name="type") String type) {
        List stakeholderAlias = this.stakeholderService.getAllAliases(type);
        if (type == null) {
            stakeholderAlias.add("all");
            stakeholderAlias.add("default");
            stakeholderAlias.add("alias");
        }
        return ResponseEntity.ok((Object)stakeholderAlias);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#buildStakeholder.stakeholder.getType()))")
    @RequestMapping(value={"/build-stakeholder"}, method={RequestMethod.POST})
    public ResponseEntity<?> buildStakeholder(@RequestBody BuildStakeholder buildStakeholder) {
        this.log.debug("build stakeholders");
        List stakeholders = this.stakeholderService.buildStakeholders(buildStakeholder);
        this.log.debug("Alias: " + stakeholders.stream().map(Common::getAlias).toString());
        stakeholders.forEach(stakeholder -> {
            Portal portal = this.portalService.getPortal(stakeholder.getAlias());
            if (portal == null) {
                portal = new Portal();
                portal.setPid(stakeholder.getAlias());
                portal.setName(stakeholder.getName());
                portal.setType(stakeholder.getType());
                this.portalService.insertPortal(portal);
            }
        });
        if (stakeholders.size() == 1) {
            return ResponseEntity.ok((Object)((Stakeholder)stakeholders.get(0)));
        }
        return ResponseEntity.ok((Object)stakeholders);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/stakeholder/all"}, method={RequestMethod.GET})
    public ResponseEntity<List<Stakeholder>> getAllStakeholders(@RequestParam(required=false, name="type") String type) {
        return ResponseEntity.ok((Object)this.stakeholderService.getAll(type));
    }

    @RequestMapping(value={"/stakeholder"}, method={RequestMethod.GET})
    public ResponseEntity<List<Stakeholder>> getVisibleStakeholders(@RequestParam(required=false, name="type") String type, @RequestParam(required=false, name="defaultId") String defaultId) {
        return ResponseEntity.ok((Object)this.stakeholderService.getVisibleStakeholders(type, defaultId));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/my-stakeholder"}, method={RequestMethod.GET})
    public ResponseEntity<ManageStakeholders> getManagedStakeholders(@RequestParam(required=false, name="type") String type) {
        return ResponseEntity.ok((Object)this.stakeholderService.getManageStakeholders(type));
    }

    @RequestMapping(value={"/stakeholder/{alias:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<StakeholderFull> getStakeholder(@PathVariable(value="alias") String alias) {
        return ResponseEntity.ok((Object)this.stakeholderService.getFull(this.stakeholderService.findByAlias(alias)));
    }

    @RequestMapping(value={"/stakeholder/{parent:.+}/{type}/{child:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<StakeholderFull> getStakeholderWithParent(@PathVariable(value="parent") String parent, @PathVariable(value="type") String type, @PathVariable(value="child") String child) {
        return ResponseEntity.ok((Object)this.stakeholderService.getFullWithParents(this.stakeholderService.findByAlias(child), type, parent));
    }

    @RequestMapping(value={"/stakeholder/{alias:.+}/change"}, method={RequestMethod.POST})
    public ResponseEntity<ManageStakeholders> changeStakeholderOptions(@PathVariable(value="alias") String alias, @RequestBody StakeholderOptions options) {
        this.log.debug("update stakeholder options: {}", (Object)alias);
        this.stakeholderService.save(this.stakeholderService.setStakeholderOptions(this.stakeholderService.findByAlias(alias), options));
        return ResponseEntity.ok((Object)this.stakeholderService.getManageStakeholders());
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#stakeholder.getType()), @AuthorizationService.manager(#stakeholder.getType(), #stakeholder.getAlias()) )")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseEntity<Stakeholder> saveStakeholder(@RequestBody Stakeholder stakeholder) {
        this.log.debug("save stakeholder");
        this.log.debug("Alias: " + stakeholder.getAlias() + " - Id: " + stakeholder.getId());
        return ResponseEntity.ok((Object)this.stakeholderService.save(this.stakeholderService.secure(stakeholder)));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#stakeholder.getType()), @AuthorizationService.manager(#stakeholder.getType(), #stakeholder.getAlias()) )")
    @RequestMapping(value={"/save/full"}, method={RequestMethod.POST})
    public ResponseEntity<StakeholderFull> saveStakeholderFull(@RequestBody StakeholderFull stakeholder) {
        this.log.debug("save stakeholder full");
        this.log.debug("Alias: " + stakeholder.getAlias() + " - Id: " + stakeholder.getId());
        return ResponseEntity.ok((Object)this.stakeholderService.getFull(this.stakeholderService.save(this.stakeholderService.secure(new Stakeholder((StakeholderGeneric)stakeholder)))));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<Boolean> deleteStakeholder(@PathVariable(value="stakeholderId") String id) {
        this.log.debug("delete stakeholder");
        this.log.debug("Id: " + id);
        Portal portal = this.portalService.getPortal(this.stakeholderService.delete(id));
        if (portal != null) {
            this.portalService.deletePortal(portal.getId());
        }
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/change-visibility"}, method={RequestMethod.POST})
    public ResponseEntity<StakeholderFull> changeStakeholderVisibility(@PathVariable(value="stakeholderId") String stakeholderId, @RequestParam(value="visibility") String visibility, @RequestParam(defaultValue="false", name="propagate") Boolean propagate) {
        this.log.debug("change stakeholder visibility: " + visibility + " - toggle propagate: " + propagate);
        this.log.debug("Stakeholder: " + stakeholderId);
        return ResponseEntity.ok((Object)this.stakeholderService.changeVisibility(this.stakeholderService.findByPath(stakeholderId), visibility, propagate));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/umbrella"}, method={RequestMethod.POST})
    public ResponseEntity<Umbrella<Stakeholder>> updateUmbrella(@PathVariable(value="stakeholderId") String stakeholderId, @RequestBody UpdateUmbrella update) {
        this.log.debug("update stakeholder umbrella");
        this.log.debug("Stakeholder: " + stakeholderId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        return ResponseEntity.ok((Object)this.stakeholderService.updateUmbrella(stakeholder, update));
    }
}

