/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.service;

import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.common.CommonRepository;
import eu.dnetlib.uoamonitorservice.common.CommonService;
import eu.dnetlib.uoamonitorservice.common.Void;
import eu.dnetlib.uoamonitorservice.dao.CategoryRepository;
import eu.dnetlib.uoamonitorservice.dto.CategoryFull;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.service.SubCategoryService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryService
extends CommonService<Category, CategoryFull, Topic> {
    SubCategoryService subCategoryService;

    @Autowired
    public CategoryService(AuthorizationService authorizationService, CategoryRepository repository, SubCategoryService subCategoryService) {
        super(authorizationService, (CommonRepository)repository);
        this.subCategoryService = subCategoryService;
        this.childService = subCategoryService;
    }

    public CategoryFull save(Stakeholder stakeholder, Topic topic, Category category) {
        boolean isNew = category.getId() == null;
        CategoryFull categoryFull = (CategoryFull)super.save(stakeholder, (Common)category, (Void)topic, "categories", null);
        if (isNew) {
            this.subCategoryService.save(stakeholder, category, category.createOverview());
            categoryFull = (CategoryFull)this.getFull(stakeholder, category.getId());
        }
        return categoryFull;
    }

    public Stakeholder reorder(Stakeholder stakeholder, Topic topic, List<String> categories) {
        return super.reorder(stakeholder, (Void)topic, "categories", categories);
    }
}

