/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoamonitorservice.dto.MoveEntity;
import eu.dnetlib.uoamonitorservice.dto.SectionFull;
import eu.dnetlib.uoamonitorservice.dto.StakeholderFull;
import eu.dnetlib.uoamonitorservice.dto.SubCategoryFull;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Section;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.SubCategory;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.service.CategoryService;
import eu.dnetlib.uoamonitorservice.service.SectionService;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import eu.dnetlib.uoamonitorservice.service.SubCategoryService;
import eu.dnetlib.uoamonitorservice.service.TopicService;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SectionController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final StakeholderService stakeholderService;
    private final TopicService topicService;
    private final CategoryService categoryService;
    private final SubCategoryService subCategoryService;
    private final SectionService sectionService;

    @Autowired
    public SectionController(StakeholderService stakeholderService, TopicService topicService, CategoryService categoryService, SubCategoryService subCategoryService, SectionService sectionService) {
        this.stakeholderService = stakeholderService;
        this.topicService = topicService;
        this.categoryService = categoryService;
        this.subCategoryService = subCategoryService;
        this.sectionService = sectionService;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/save-bulk"}, method={RequestMethod.POST})
    public ResponseEntity<StakeholderFull> saveBulkIndicators(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @RequestBody List<SectionFull> sections) throws UnsupportedEncodingException {
        this.log.debug("save bulk indicators");
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        SubCategory subCategory = (SubCategory)this.subCategoryService.findByPath(stakeholder, category, subcategoryId);
        stakeholder = this.sectionService.saveBulk(stakeholder, subCategory, sections);
        return ResponseEntity.ok((Object)this.stakeholderService.getFull(stakeholder));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/save/{index}"}, method={RequestMethod.POST})
    public ResponseEntity<SectionFull> saveSection(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="index") String index, @RequestBody SectionFull sectionFull) {
        this.log.debug("save section");
        this.log.debug("Name: " + sectionFull.getTitle() + " - Id: " + sectionFull.getId() + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        SubCategory subCategory = (SubCategory)this.subCategoryService.findByPath(stakeholder, category, subcategoryId);
        if (sectionFull.getId() != null) {
            this.sectionService.findByPath(stakeholder, subCategory, sectionFull.getId());
        }
        return ResponseEntity.ok((Object)this.sectionService.save(stakeholder, subCategory, new Section(sectionFull), Integer.parseInt(index)));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<Boolean> deleteSection(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId) {
        this.log.debug("delete section");
        this.log.debug("Id: " + sectionId + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        SubCategory subCategory = (SubCategory)this.subCategoryService.findByPath(stakeholder, category, subcategoryId);
        Section section = (Section)this.sectionService.findByPath(stakeholder, subCategory, sectionId);
        this.sectionService.delete(stakeholder, section.getId());
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/moveIndicator"}, method={RequestMethod.POST})
    public ResponseEntity<SubCategoryFull> moveIndicator(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @RequestBody MoveEntity moveEntity) {
        this.log.debug("move indicator");
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        SubCategory subCategory = (SubCategory)this.subCategoryService.findByPath(stakeholder, category, subcategoryId);
        return ResponseEntity.ok((Object)((SubCategoryFull)this.subCategoryService.getFull(this.sectionService.move(stakeholder, subCategory, moveEntity), subcategoryId)));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/reset"}, method={RequestMethod.POST})
    public ResponseEntity<SectionFull> reset(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId) {
        this.log.debug("restore to default topic");
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        SubCategory subCategory = (SubCategory)this.subCategoryService.findByPath(stakeholder, category, subcategoryId);
        Section section = (Section)this.sectionService.findByPath(stakeholder, subCategory, sectionId);
        return ResponseEntity.ok((Object)((SectionFull)this.sectionService.restoreDefault(stakeholder, section)));
    }
}

