/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.common;

import com.mongodb.BasicDBObject;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.common.Void;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.handlers.BadRequestException;
import eu.dnetlib.uoamonitorservice.utils.GenericAccessor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.springframework.core.ResolvableType;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class CommonRepository<Entity extends Common, Parent extends Void> {
    protected final Class<Entity> entityClass;
    protected final Class<Parent> parentClass;
    protected final MongoTemplate mongoTemplate;

    public CommonRepository(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
        ResolvableType type = ResolvableType.forClass(this.getClass()).as(CommonRepository.class);
        this.entityClass = type.getGeneric(new int[]{0}).resolve();
        this.parentClass = type.getGeneric(new int[]{1}).resolve();
    }

    public Stakeholder getStakeholder(String id) {
        return (Stakeholder)this.mongoTemplate.findById((Object)id, Stakeholder.class);
    }

    public Entity findById(String id) {
        return (Entity)this.findById(id, true);
    }

    public Entity findById(String id, boolean trowException) {
        Common entity = (Common)this.mongoTemplate.findById((Object)id, this.entityClass);
        if (entity == null && trowException) {
            throw new NotFoundException(this.entityClass.getName() + " with id: " + id + " not found");
        }
        return (Entity)entity;
    }

    public Parent findParent(String id) {
        Void parent = (Void)this.mongoTemplate.findById((Object)id, this.parentClass);
        if (parent == null) {
            throw new NotFoundException(this.parentClass.getName() + " with id: " + id + " not found");
        }
        return (Parent)parent;
    }

    public Entity save(Stakeholder stakeholder, Entity entity) {
        if (entity == null) {
            throw new BadRequestException(this.entityClass.getName() + " cannot be null");
        }
        if (stakeholder != null) {
            stakeholder.setOverride(entity.getId(), entity.override(this.findById(entity.getId()), stakeholder.getOverride(entity.getId()).keySet()), this.entityClass);
            entity.override((Stakeholder)this.mongoTemplate.save((Object)stakeholder));
            return entity;
        }
        return (Entity)((Common)this.mongoTemplate.save(entity));
    }

    public Entity save(Entity entity) {
        return (Entity)this.save(null, entity);
    }

    private void initializeOverrideChildren(Stakeholder stakeholder, Parent parent, String children) {
        if (parent instanceof Common) {
            Common p = (Common)parent;
            Criteria existsCriteria = Criteria.where((String)"_id").is((Object)new ObjectId(stakeholder.getId())).and("overrides." + p.getId() + "." + children).exists(false);
            Update update = new Update().set("overrides." + p.getId() + "." + children, (Object)((Common)this.findParent(p.getId())).getChildren(children));
            update.set("overrides." + p.getId() + ".className", (Object)this.parentClass.getName());
            this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)existsCriteria), (UpdateDefinition)update, Stakeholder.class);
        }
    }

    public Stakeholder addChild(Stakeholder stakeholder, String id, Parent parent, String children, Integer index) {
        if (this.parentClass == Void.class) {
            return null;
        }
        if (parent == null) {
            throw new BadRequestException(this.parentClass.getName() + " cannot be null");
        }
        if (parent instanceof Common) {
            Common p = (Common)parent;
            if (!p.isChildrenField(children)) {
                throw new BadRequestException(children + " is not a @Children field in " + this.parentClass.getName());
            }
            BasicDBObject element = new BasicDBObject("$each", Collections.singletonList(id));
            if (index != null && index >= 0) {
                element.put("$position", (Object)index);
            }
            if (p.isOwnedBy(stakeholder) && p.canModifyChildren()) {
                Update update = new Update().push(children, (Object)element);
                Criteria criteria = Criteria.where((String)"_id").is((Object)new ObjectId(p.getId()));
                this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, this.mongoTemplate.getCollectionName(this.parentClass));
                criteria = Criteria.where((String)"defaultId").is((Object)stakeholder.getId()).and("overrides." + p.getId() + "." + children).exists(true);
                this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), Stakeholder.class).forEach(child -> {
                    Criteria childCriteria = Criteria.where((String)"_id").is((Object)new ObjectId(child.getId()));
                    BasicDBObject childElement = new BasicDBObject("$each", Collections.singletonList(id));
                    if (index != null && index >= 0) {
                        childElement.put("$position", (Object)index);
                    }
                    Update childUpdate = new Update().push("overrides." + p.getId() + "." + children, (Object)childElement);
                    this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)childCriteria), (UpdateDefinition)childUpdate, Stakeholder.class);
                });
            } else {
                this.initializeOverrideChildren(stakeholder, parent, children);
                Update update = new Update().push("overrides." + p.getId() + "." + children, (Object)element);
                Criteria criteria = Criteria.where((String)"_id").is((Object)new ObjectId(stakeholder.getId()));
                this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, Stakeholder.class);
                stakeholder = this.getStakeholder(stakeholder.getId());
            }
        } else {
            throw new BadRequestException(id + " cannot be added to parent");
        }
        return stakeholder;
    }

    public Stakeholder reorder(Stakeholder stakeholder, Parent parent, String children, List<String> ids) {
        if (parent == null) {
            throw new BadRequestException(this.parentClass.getName() + " cannot be null");
        }
        if (parent instanceof Common) {
            Common p = (Common)parent;
            if (p.isOwnedBy(stakeholder) && p.canModifyChildren()) {
                Update update = new Update().set(children, ids);
                Criteria criteria = Criteria.where((String)"_id").is((Object)new ObjectId(p.getId()));
                this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, this.mongoTemplate.getCollectionName(this.parentClass));
            } else {
                this.initializeOverrideChildren(stakeholder, parent, children);
                Update update = new Update().set("overrides." + p.getId() + "." + children, ids);
                Criteria criteria = Criteria.where((String)"_id").is((Object)new ObjectId(stakeholder.getId()));
                this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)criteria), (UpdateDefinition)update, Stakeholder.class);
                stakeholder = this.getStakeholder(stakeholder.getId());
            }
            return stakeholder;
        }
        throw new BadRequestException(children + " cannot be reordered to this parent");
    }

    public void delete(Stakeholder stakeholder, Entity entity) {
        if (entity == null) {
            throw new BadRequestException(this.entityClass.getName() + " cannot be null");
        }
        if (stakeholder == null) {
            throw new BadRequestException(Stakeholder.class.getName() + " cannot be null");
        }
        List childrenFields = GenericAccessor.getChildrenFields((Class)this.parentClass);
        if (stakeholder.isReference()) {
            Stakeholder s = stakeholder;
            if (this.parentClass == Stakeholder.class) {
                childrenFields.forEach(field -> this.initializeOverrideChildren(s, (Void)s, field));
            } else {
                childrenFields.forEach(field -> this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"parentId").is((Object)s.getDefaultId()).and(field).is((Object)entity.getId())), this.parentClass).forEach(result -> this.initializeOverrideChildren(s, result, field)));
            }
            stakeholder = this.getStakeholder(stakeholder.getId());
            if (stakeholder == null) {
                throw new BadRequestException(Stakeholder.class.getName() + " cannot be null");
            }
        }
        Query query = new Query((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"parentId").is((Object)stakeholder.getId()), Criteria.where((String)"_id").is((Object)new ObjectId(stakeholder.getId()))}));
        Update update = new Update();
        for (String field2 : childrenFields) {
            update.pull(field2, (Object)entity.getId());
        }
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, this.parentClass);
        if (stakeholder.isReference()) {
            query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(stakeholder.getId())).and("overrides").exists(true));
            update = new Update().unset("overrides." + entity.getId());
            for (String parentId : stakeholder.getEntitiesFromOverrides(this.parentClass)) {
                for (String field3 : childrenFields) {
                    update.pull("overrides." + parentId + "." + field3, (Object)entity.getId());
                }
            }
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, Stakeholder.class);
        } else {
            query = new Query((CriteriaDefinition)Criteria.where((String)"defaultId").is((Object)stakeholder.getId()).and("overrides").exists(true));
            this.mongoTemplate.find(query, Stakeholder.class).forEach(result -> {
                Update updateChild = new Update().unset("overrides." + entity.getId());
                for (String parentId : result.getEntitiesFromOverrides(this.parentClass)) {
                    for (String field : childrenFields) {
                        updateChild.pull("overrides." + parentId + "." + field, (Object)entity.getId());
                    }
                }
                this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(result.getId()))), (UpdateDefinition)updateChild, Stakeholder.class);
            });
        }
        stakeholder = this.getStakeholder(stakeholder.getId());
        if (stakeholder == null) {
            throw new BadRequestException(Stakeholder.class.getName() + " cannot be null");
        }
        if (entity.isOwnedBy(stakeholder)) {
            this.mongoTemplate.remove(entity, this.mongoTemplate.getCollectionName(this.entityClass));
        }
    }

    public void deleteOverride(Stakeholder stakeholder, Entity entity) {
        stakeholder = this.getStakeholder(stakeholder.getId());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(stakeholder.getId())).and("overrides").exists(true));
        Update update = new Update();
        Map override = stakeholder.getOverride(entity.getId());
        List restorableFields = GenericAccessor.getRestorableFields((Class)this.entityClass);
        if (new HashSet(restorableFields).containsAll(override.keySet().stream().filter(key -> !key.equals("className")).toList())) {
            update.unset("overrides." + entity.getId());
        } else {
            for (String key2 : override.keySet()) {
                if (!restorableFields.contains(key2)) continue;
                update.unset("overrides." + entity.getId() + "." + key2);
            }
        }
        if (!update.getUpdateObject().isEmpty()) {
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, Stakeholder.class);
        }
    }
}

