/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoamonitorservice.dto.CategoryFull;
import eu.dnetlib.uoamonitorservice.dto.TopicFull;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.service.CategoryService;
import eu.dnetlib.uoamonitorservice.service.StakeholderService;
import eu.dnetlib.uoamonitorservice.service.TopicService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CategoryController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final StakeholderService stakeholderService;
    private final TopicService topicService;
    private final CategoryService categoryService;

    @Autowired
    public CategoryController(StakeholderService stakeholderService, TopicService topicService, CategoryService categoryService) {
        this.stakeholderService = stakeholderService;
        this.topicService = topicService;
        this.categoryService = categoryService;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/save"}, method={RequestMethod.POST})
    public ResponseEntity<CategoryFull> saveCategory(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @RequestBody CategoryFull categoryFull) {
        this.log.debug("save category");
        this.log.debug("Alias: " + categoryFull.getAlias() + " - Id: " + categoryFull.getId() + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        if (categoryFull.getId() != null) {
            this.categoryService.findByPath(stakeholder, topic, categoryFull.getId());
        }
        return ResponseEntity.ok((Object)this.categoryService.save(stakeholder, topic, new Category(categoryFull)));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<Boolean> deleteCategory(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId) {
        this.log.debug("delete category");
        this.log.debug("Id: " + categoryId + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        this.categoryService.delete(stakeholder, category.getId());
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/reorder"}, method={RequestMethod.POST})
    public ResponseEntity<List<CategoryFull>> reorderCategories(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @RequestBody List<String> categories) {
        this.log.debug("reorder categories");
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        return ResponseEntity.ok(((TopicFull)this.topicService.getFull(this.categoryService.reorder(stakeholder, topic, categories), topicId)).getCategories());
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/change-visibility"}, method={RequestMethod.POST})
    public ResponseEntity<CategoryFull> changeCategoryVisibility(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @RequestParam(value="visibility") String visibility, @RequestParam(defaultValue="false", name="propagate") Boolean propagate) {
        this.log.debug("change category visibility: " + visibility + " - toggle propagate: " + propagate);
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        return ResponseEntity.ok((Object)((CategoryFull)this.categoryService.changeVisibility(stakeholder, category, visibility, propagate)));
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/reset"}, method={RequestMethod.POST})
    public ResponseEntity<CategoryFull> reset(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId) {
        this.log.debug("restore to default topic");
        this.log.debug("Stakeholder: " + stakeholderId + " - Topic: " + topicId);
        Stakeholder stakeholder = this.stakeholderService.findByPath(stakeholderId);
        Topic topic = this.topicService.findByPath(stakeholder, topicId);
        Category category = (Category)this.categoryService.findByPath(stakeholder, topic, categoryId);
        return ResponseEntity.ok((Object)((CategoryFull)this.categoryService.restoreDefault(stakeholder, category)));
    }
}

