/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.utils;

import eu.dnetlib.uoamonitorservice.annotations.Children;
import eu.dnetlib.uoamonitorservice.annotations.Overridable;
import eu.dnetlib.uoamonitorservice.annotations.Unmodifiable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GenericAccessor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> void setField(Object obj, String fieldName, T value) {
        try {
            Field field = GenericAccessor.findField(obj.getClass(), fieldName);
            field.setAccessible(true);
            if (field.getType().isEnum()) {
                if (value instanceof String) {
                    String stringValue = (String)value;
                    Object enumValue = GenericAccessor.getEnumValue(field.getType(), stringValue);
                    field.set(obj, enumValue);
                    return;
                } else {
                    if (!field.getType().isAssignableFrom(value.getClass())) throw new IllegalArgumentException("Incompatible types: cannot assign " + value.getClass().getName() + " to " + field.getType().getName());
                    field.set(obj, value);
                }
                return;
            } else {
                field.set(obj, value);
            }
            return;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.err.println("Error setting field: " + e.getMessage());
        }
    }

    public static Object getField(Object obj, String fieldName) {
        try {
            Field field = GenericAccessor.findField(obj.getClass(), fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.err.println("Error getting field: " + e.getMessage());
            return null;
        }
    }

    private static Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException("Field '" + fieldName + "' not found in class hierarchy of " + clazz.getName());
    }

    private static <E extends Enum<E>> E getEnumValue(Class<?> enumClass, String value) {
        return (E)Enum.valueOf(enumClass, value);
    }

    public static List<String> getChildrenFields(Class<?> clazz) {
        return GenericAccessor.getAnnotatedFields(clazz, Children.class).stream().map(Field::getName).toList();
    }

    public static List<String> getUnmodifiableFields(Class<?> clazz) {
        return GenericAccessor.getAnnotatedFields(clazz, Unmodifiable.class).stream().map(Field::getName).toList();
    }

    public static List<String> getRestorableFields(Class<?> clazz) {
        return GenericAccessor.getAnnotatedFields(clazz, Overridable.class).stream().filter(field -> field.getAnnotation(Overridable.class).restorable()).map(Field::getName).toList();
    }

    public static List<Field> getOverridableFields(Class<?> clazz) {
        return GenericAccessor.getAnnotatedFields(clazz, Overridable.class);
    }

    private static List<Field> getAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotation) {
        return GenericAccessor.getDeclaredFields(clazz).stream().filter(field -> field.isAnnotationPresent(annotation)).toList();
    }

    private static List<Field> getDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            fields.addAll(Arrays.stream(currentClass.getDeclaredFields()).toList());
        }
        return fields;
    }
}

