/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.email.Email;
import eu.dnetlib.uoaadmintoolslibrary.entities.email.EmailRecaptcha;
import eu.dnetlib.uoaadmintoolslibrary.exceptions.InvalidReCaptchaException;
import eu.dnetlib.uoaadmintoolslibrary.services.EmailService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EmailController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final EmailService service;

    @Autowired
    public EmailController(EmailService service) {
        this.service = service;
    }

    @RequestMapping(value={"/contact"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> contact(@RequestBody EmailRecaptcha form) throws InvalidReCaptchaException {
        this.service.processResponse(form.getRecaptcha());
        Email email = form.getEmail();
        return ResponseEntity.ok((Object)this.service.send(email.getRecipients(), email.getSubject(), email.getBody(), Boolean.valueOf(false)));
    }

    @RequestMapping(value={"/sendMail"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, ArrayList<String>>> sendEmail(@RequestBody Email email, @RequestParam(required=false, name="optional") Optional<Boolean> optional) {
        String successString = "success";
        String failureString = "failure";
        HashMap mailResults = new HashMap();
        boolean bcc = optional.orElse(true);
        for (String userMail : email.getRecipients()) {
            ArrayList<String> sendTo = new ArrayList<String>();
            sendTo.add(userMail);
            boolean success = this.service.send(sendTo, email.getSubject(), email.getBody(), Boolean.valueOf(bcc));
            if (success) {
                if (!mailResults.containsKey(successString)) {
                    mailResults.put(successString, new ArrayList());
                }
                ((ArrayList)mailResults.get(successString)).add(userMail);
                continue;
            }
            if (!mailResults.containsKey(failureString)) {
                mailResults.put(failureString, new ArrayList());
            }
            ((ArrayList)mailResults.get(failureString)).add(userMail);
        }
        return ResponseEntity.ok(mailResults);
    }
}

