/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.service;

import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.common.CommonRepository;
import eu.dnetlib.uoamonitorservice.common.CommonService;
import eu.dnetlib.uoamonitorservice.common.Void;
import eu.dnetlib.uoamonitorservice.dao.SectionRepository;
import eu.dnetlib.uoamonitorservice.dto.MoveEntity;
import eu.dnetlib.uoamonitorservice.dto.SectionFull;
import eu.dnetlib.uoamonitorservice.entities.Section;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.SubCategory;
import eu.dnetlib.uoamonitorservice.primitives.IndicatorType;
import eu.dnetlib.uoamonitorservice.service.IndicatorService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SectionService
extends CommonService<Section, SectionFull, SubCategory> {
    @Autowired
    public SectionService(AuthorizationService authorizationService, SectionRepository repository, IndicatorService indicatorService) {
        super(authorizationService, (CommonRepository)repository);
        this.childService = indicatorService;
    }

    public SectionFull save(Stakeholder stakeholder, SubCategory subCategory, Section section, Integer index) {
        String children = section.getType().equals(IndicatorType.NUMBER.getLabel()) ? "numbers" : "charts";
        return (SectionFull)super.save(stakeholder, (Common)section, (Void)subCategory, children, index);
    }

    public void saveFull(Stakeholder stakeholder, SubCategory subCategory, SectionFull section) {
        String children = section.getType().equals(IndicatorType.NUMBER.getLabel()) ? "numbers" : "charts";
        super.saveFull(stakeholder, (Common)section, (Void)subCategory, children);
    }

    public Stakeholder move(Stakeholder stakeholder, SubCategory subCategory, MoveEntity moveEntity) {
        return super.move(stakeholder, (Void)subCategory, moveEntity, "indicators");
    }

    public Stakeholder saveBulk(Stakeholder stakeholder, SubCategory subCategory, List<SectionFull> sections) {
        sections.forEach(section -> this.saveFull(stakeholder, subCategory, section));
        return this.repository.getStakeholder(stakeholder.getId());
    }
}

