/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoanotificationservice.controllers;

import eu.dnetlib.uoanotificationservice.configuration.NotificationConfiguration;
import eu.dnetlib.uoanotificationservice.configuration.NotificationMongoConnection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notification-service"})
public class NotificationServiceCheckDeployController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final NotificationMongoConnection mongoConnection;
    private final NotificationConfiguration configuration;

    @Autowired
    public NotificationServiceCheckDeployController(NotificationMongoConnection mongoConnection, NotificationConfiguration configuration) {
        this.mongoConnection = mongoConnection;
        this.configuration = configuration;
    }

    @RequestMapping(value={"", "/"}, method={RequestMethod.GET})
    public ResponseEntity<String> hello() {
        this.log.debug("Hello from uoa-notification-service!");
        return ResponseEntity.ok((Object)"Hello from uoa-notification-service!");
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/configuration"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> checkEverything() {
        Map<String, String> response = this.configuration.getProperties();
        MongoTemplate mt = this.mongoConnection.getMongoTemplate();
        Document ping = new Document("ping", (Object)1);
        try {
            Document answer = mt.executeCommand(ping);
            response.put("Mongo try: error", String.valueOf(answer.getDouble((Object)"ok") == 1.0));
        }
        catch (Exception e) {
            response.put("Mongo catch: error", e.getMessage());
        }
        return ResponseEntity.ok(response);
    }
}

