/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoanotificationservice.utils;

import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoanotificationservice.dao.NotificationDAO;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Utils")
public class Utils {
    private static final String EMAIL_REGEX = "^(?=.{1,64}@)[A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)*@[^-][A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";
    private final AuthorizationService authorizationService;
    private final NotificationDAO notificationDAO;

    @Autowired
    public Utils(AuthorizationService authorizationService, NotificationDAO notificationDAO) {
        this.authorizationService = authorizationService;
        this.notificationDAO = notificationDAO;
    }

    public static boolean isValidEmail(String emailAddress) {
        return Pattern.compile(EMAIL_REGEX).matcher(emailAddress).matches();
    }

    public boolean canRead(String id) {
        HashSet<String> groups = new HashSet<String>(this.authorizationService.getRoles());
        groups.add("all");
        groups.add(this.authorizationService.getEmail().toLowerCase());
        return this.notificationDAO.findByIdAndUserNotAndGroupsIn(id, this.authorizationService.getAaiId(), groups).isPresent();
    }

    public boolean hasValidGroups(Set<String> groups, String stakeholderType) {
        HashSet<String> roles = new HashSet<String>(this.authorizationService.getRoles());
        if (stakeholderType != null) {
            roles.add(this.authorizationService.curator(stakeholderType));
        }
        HashSet<String> check = new HashSet<String>(groups);
        Set<String> types = this.getCuratorTypes(roles);
        Objects.requireNonNull(this.authorizationService);
        if (roles.contains("PORTAL_ADMINISTRATOR")) {
            return true;
        }
        if (groups.contains("all")) {
            return false;
        }
        return check.stream().filter(group -> {
            if (Utils.isValidEmail(group)) {
                return false;
            }
            for (String type : types) {
                if (!group.contains(type)) continue;
                return false;
            }
            return true;
        }).allMatch(roles::contains);
    }

    private Set<String> getCuratorTypes(Set<String> roles) {
        return roles.stream().filter(role -> role.contains("CURATOR_")).map(curator -> curator.replace("CURATOR_", "")).collect(Collectors.toSet());
    }
}

