/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoanotificationservice.configuration;

import eu.dnetlib.uoaauthorizationlibrary.AuthorizationConfiguration;
import eu.dnetlib.uoanotificationservice.configuration.GlobalVars;
import eu.dnetlib.uoanotificationservice.configuration.MongoConfig;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableConfigurationProperties(value={MongoConfig.class, GlobalVars.class})
@EnableScheduling
@ComponentScan(basePackages={"eu.dnetlib.uoanotificationservice"})
@Import(value={AuthorizationConfiguration.class})
public class NotificationConfiguration {
    private final MongoConfig mongoConfig;
    private final GlobalVars globalVars;

    @Autowired
    public NotificationConfiguration(MongoConfig mongoConfig, GlobalVars globalVars) {
        this.mongoConfig = mongoConfig;
        this.globalVars = globalVars;
    }

    @PostConstruct
    public void checkProperties() {
        if (this.mongoConfig.getDatabase() == null || this.mongoConfig.getDatabase().isEmpty()) {
            throw new RuntimeException("notification.mongodb.database is missing!");
        }
        if (this.mongoConfig.getHost() == null || this.mongoConfig.getHost().isEmpty()) {
            throw new RuntimeException("notification.mongodb.host is missing!");
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("notification.mongodb.database", this.mongoConfig.getDatabase());
        response.put("notification.mongodb.host", this.mongoConfig.getHost());
        response.put("notification.mongodb.port", String.valueOf(this.mongoConfig.getPort()));
        response.put("notification.mongodb.username", this.mongoConfig.getUsername());
        response.put("notification.mongodb.password", this.mongoConfig.getPassword());
        response.put("Date of deploy", GlobalVars.date.toString());
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            response.put("Version", this.globalVars.getVersion());
        }
        return response;
    }
}

