/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoanotificationservice.configuration;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import eu.dnetlib.uoanotificationservice.configuration.MongoConfig;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"eu.dnetlib.uoanotificationservice.dao"}, mongoTemplateRef="notificationTemplate")
public class NotificationMongoConnection {
    private final MongoConfig mongoConfig;

    @Autowired
    public NotificationMongoConnection(MongoConfig mongoConfig) {
        this.mongoConfig = mongoConfig;
    }

    @Bean(name={"notificationDatabaseFactory"})
    public MongoDatabaseFactory notificationDatabaseFactory(@Qualifier(value="notificationClient") MongoClient mongoClient) {
        return new SimpleMongoClientDatabaseFactory(mongoClient, this.mongoConfig.getDatabase());
    }

    @Bean(name={"notificationMappingContext"})
    public MongoMappingContext notificationMappingContext() {
        return new MongoMappingContext();
    }

    @Bean(name={"notificationMappingConverter"})
    public MappingMongoConverter mappingMongoConverter(@Qualifier(value="notificationDatabaseFactory") MongoDatabaseFactory factory, @Qualifier(value="notificationMappingContext") MongoMappingContext context) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        return new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
    }

    @Bean(name={"notificationTemplate"})
    public MongoTemplate getMongoTemplate(@Qualifier(value="notificationClient") MongoClient mongoClient) {
        return new MongoTemplate(mongoClient, this.mongoConfig.getDatabase());
    }

    @Bean(name={"notificationClient"})
    public MongoClient getMongoClient() {
        MongoClientSettings.Builder builder = MongoClientSettings.builder().applyToClusterSettings(b -> b.hosts(Collections.singletonList(new ServerAddress(this.mongoConfig.getHost(), this.mongoConfig.getPort()))));
        if (this.mongoConfig.getUsername() != null && this.mongoConfig.getPassword() != null) {
            MongoCredential credential = MongoCredential.createCredential((String)this.mongoConfig.getUsername(), (String)this.mongoConfig.getDatabase(), (char[])this.mongoConfig.getPassword().toCharArray());
            builder.credential(credential);
        }
        return MongoClients.create((MongoClientSettings)builder.build());
    }
}

