/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoanotificationservice.controllers;

import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoanotificationservice.entities.Notification;
import eu.dnetlib.uoanotificationservice.entities.User;
import eu.dnetlib.uoanotificationservice.services.NotificationService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notification"})
public class NotificationController {
    private final NotificationService notificationService;
    private final AuthorizationService authorizationService;

    @Autowired
    public NotificationController(NotificationService notificationService, AuthorizationService authorizationService) {
        this.notificationService = notificationService;
        this.authorizationService = authorizationService;
    }

    @PreAuthorize(value="hasAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    public ResponseEntity<List<Notification>> getAllNotifications() {
        return ResponseEntity.ok(this.notificationService.getAllNotifications());
    }

    @PreAuthorize(value="hasAuthority(@AuthorizationService.REGISTERED_USER)")
    @RequestMapping(value={"/{service}"}, method={RequestMethod.GET})
    public ResponseEntity<List<Notification>> getMyNotifications(@PathVariable String service) {
        return ResponseEntity.ok(this.notificationService.getMyNotifications(this.authorizationService.getAaiId(), this.authorizationService.getEmail(), service, this.authorizationService.getRoles()));
    }

    @PreAuthorize(value="hasAuthority(@AuthorizationService.REGISTERED_USER)")
    @RequestMapping(value={"/all/{service}"}, method={RequestMethod.PUT})
    public ResponseEntity<User> markAllAsRead(@PathVariable String service) {
        List<Notification> notifications = this.notificationService.getMyNotifications(this.authorizationService.getAaiId(), this.authorizationService.getEmail(), service, this.authorizationService.getRoles());
        return ResponseEntity.ok((Object)this.notificationService.readAllNotifications(notifications, this.authorizationService.getAaiId()));
    }

    @PreAuthorize(value="hasAuthority(@AuthorizationService.REGISTERED_USER) && @Utils.hasValidGroups(#notification.groups, #notification.stakeholderType)")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseEntity<Notification> save(@RequestBody Notification notification) {
        notification.setUser(this.authorizationService.getAaiId());
        notification.setDate(new Date());
        notification.setRead(false);
        return ResponseEntity.ok((Object)this.notificationService.save(notification));
    }

    @PreAuthorize(value="hasAuthority(@AuthorizationService.REGISTERED_USER) && @Utils.canRead(#id)")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<User> readNotification(@PathVariable String id) {
        return ResponseEntity.ok((Object)this.notificationService.readNotification(this.authorizationService.getAaiId(), id));
    }
}

