/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoanotificationservice.services;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoanotificationservice.dao.NotificationDAO;
import eu.dnetlib.uoanotificationservice.dao.UserDAO;
import eu.dnetlib.uoanotificationservice.entities.Notification;
import eu.dnetlib.uoanotificationservice.entities.User;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class NotificationService {
    Logger logger = LogManager.getLogger(NotificationService.class);
    private final NotificationDAO notificationDAO;
    private final UserDAO userDAO;

    @Autowired
    public NotificationService(NotificationDAO notificationDAO, UserDAO userDAO) {
        this.notificationDAO = notificationDAO;
        this.userDAO = userDAO;
    }

    public List<Notification> getAllNotifications() {
        return this.notificationDAO.findByOrderByDateDesc();
    }

    public List<Notification> getMyNotifications(String userId, String email, String service, List<String> roles) {
        HashSet<String> services = new HashSet<String>();
        services.add(service);
        services.add("all");
        HashSet<String> groups = new HashSet<String>(roles);
        groups.add(email.toLowerCase());
        groups.add("all");
        List<Notification> notifications = this.notificationDAO.findByUserNotAndServicesInAndGroupsInOrderByDateDesc(userId, services, groups);
        this.userDAO.findById(userId).ifPresent(user -> notifications.forEach(notification -> notification.setRead(user.getRead().contains(notification.getId()))));
        return notifications;
    }

    public Notification save(Notification notification) {
        return (Notification)this.notificationDAO.save(notification);
    }

    public User readNotification(String userId, String id) {
        Notification notification = (Notification)this.notificationDAO.findById(id).orElseThrow(() -> new NotFoundException("Notification has not been found"));
        User user = this.userDAO.findById(userId).orElse(new User(userId, new HashSet<String>()));
        user.getRead().add(notification.getId());
        return (User)this.userDAO.save(user);
    }

    public User readAllNotifications(List<Notification> notifications, String userId) {
        User user = this.userDAO.findById(userId).orElse(new User(userId, new HashSet<String>()));
        notifications.forEach(notification -> user.getRead().add(notification.getId()));
        return (User)this.userDAO.save(user);
    }

    public void delete(String id) {
        List<User> users = this.userDAO.findByReadContains(id);
        users.forEach(user -> {
            user.getRead().remove(id);
            this.userDAO.save(user);
        });
        this.notificationDAO.deleteById(id);
    }

    @Scheduled(cron="0 0 0 1/1 * ?")
    protected void deleteNotifications() {
        this.logger.info("Deleting notifications that have been created more than a month ago");
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        List<Notification> notifications = this.notificationDAO.findByDateBefore(calendar.getTime());
        notifications.forEach(notification -> this.delete(notification.getId()));
    }
}

