/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.controllers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.ConflictException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoaorcidservice.configuration.properties.OrcidConfig;
import eu.dnetlib.uoaorcidservice.controllers.IdsStructure;
import eu.dnetlib.uoaorcidservice.entities.ResultIdAndWork;
import eu.dnetlib.uoaorcidservice.entities.UserTokens;
import eu.dnetlib.uoaorcidservice.entities.Work;
import eu.dnetlib.uoaorcidservice.services.UserTokensService;
import eu.dnetlib.uoaorcidservice.services.WorkService;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@PreAuthorize(value="isAuthenticated()")
public class WorkController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Logger orcid_log = LogManager.getLogger((String)("ORCID-" + this.getClass().getName()));
    private final OrcidConfig orcidConfig;
    private final UserTokensService userTokensService;
    private final WorkService workService;

    @Autowired
    public WorkController(OrcidConfig orcidConfig, UserTokensService userTokensService, WorkService workService) {
        this.orcidConfig = orcidConfig;
        this.userTokensService = userTokensService;
        this.workService = workService;
    }

    @RequestMapping(value={"/local/put-code"}, method={RequestMethod.GET})
    public List<String> getPutCode(@RequestParam String openaireId, @RequestParam(required=false) String[] pids) {
        String userOrcid = this.userTokensService.getCurrentUserOrcid();
        List works = this.workService.getWorks(openaireId, pids, userOrcid);
        if (works != null) {
            ArrayList<String> putCodes = new ArrayList<String>();
            for (Work work : works) {
                putCodes.add(work.getPutCode());
            }
            return putCodes;
        }
        return null;
    }

    @RequestMapping(value={"/local/put-codes"}, method={RequestMethod.POST})
    public List<List<String>> getPutCodes(@RequestBody IdsStructure map) {
        String userOrcid = this.userTokensService.getCurrentUserOrcid();
        ArrayList<List<String>> putCodes = new ArrayList<List<String>>();
        if (map.getPids() != null) {
            for (int i = 0; i < map.getPids().length; ++i) {
                List works = null;
                works = map.getPids()[i] != null ? this.workService.getWorks(null, map.getPids()[i], userOrcid) : this.workService.getWorks(map.getOpenaireIds()[i], null, userOrcid);
                this.getPutCodesFromWorks(works, putCodes);
            }
        } else {
            for (int i = 0; i < map.getOpenaireIds().length; ++i) {
                List works = this.workService.getWorks(map.getOpenaireIds()[i], null, userOrcid);
                this.getPutCodesFromWorks(works, putCodes);
            }
        }
        return putCodes;
    }

    private void getPutCodesFromWorks(List<Work> works, List<List<String>> putCodes) {
        if (works != null) {
            ArrayList<String> putCodesOfOneRecord = new ArrayList<String>();
            for (Work work : works) {
                putCodesOfOneRecord.add(work.getPutCode());
            }
            putCodes.add(putCodesOfOneRecord);
        } else {
            putCodes.add(null);
        }
    }

    @RequestMapping(value={"/local/works"}, method={RequestMethod.POST})
    public List<List<Work>> getLocalWorks(@RequestBody IdsStructure map) {
        String userOrcid = this.userTokensService.getCurrentUserOrcid();
        ArrayList<List<Work>> returnedWorks = new ArrayList<List<Work>>();
        if (map.getPids() != null) {
            for (int i = 0; i < map.getPids().length; ++i) {
                List works = this.workService.getWorks(null, map.getPids()[i], userOrcid);
                returnedWorks.add(works);
            }
        } else {
            for (int i = 0; i < map.getOpenaireIds().length; ++i) {
                List works = this.workService.getWorks(map.getOpenaireIds()[i], null, userOrcid);
                returnedWorks.add(works);
            }
        }
        return returnedWorks;
    }

    @RequestMapping(value={"/orcid/work/save"}, method={RequestMethod.POST})
    public Work saveWork(@RequestBody String resultString) throws Exception {
        this.log.debug("saveWork: result = " + resultString);
        Gson gson = new GsonBuilder().create();
        ResultIdAndWork result = (ResultIdAndWork)gson.fromJson(resultString, ResultIdAndWork.class);
        UserTokens userTokens = this.userTokensService.getUserTokens();
        String userOrcid = userTokens.getOrcid();
        String userAccessToken = userTokens.getAccessToken();
        String url = this.orcidConfig.getApiURL() + userOrcid + "/work";
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json;charset=UTF-8");
        HttpEntity request = new HttpEntity((Object)gson.toJson(result.getWork()), (MultiValueMap)headers);
        this.orcid_log.info("request: " + String.valueOf(request));
        this.orcid_log.info("url: " + url);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.CREATED) {
            this.orcid_log.error("Saving work response code is: " + String.valueOf(response.getStatusCode()));
            this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
            if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new AuthorizationServiceException("You are not allowed to save work");
            }
            if (response.getStatusCode() == HttpStatus.CONFLICT) {
                throw new ConflictException("Work is already saved");
            }
            throw new Exception("Internal server error");
        }
        this.orcid_log.info("Response: " + String.valueOf(response));
        Date date = new Date();
        Work workToSave = new Work();
        workToSave.setPids(result.getPids());
        workToSave.setOpenaireId(result.getOpenaireId());
        workToSave.setOrcid(userOrcid);
        workToSave.setCreationDate(date);
        workToSave.setUpdateDate(date);
        workToSave.setDashboard(result.getDashboard());
        HttpHeaders responseHeaders = response.getHeaders();
        String locationPath = responseHeaders.getLocation().toString();
        String[] locationPathArray = locationPath.split("/");
        workToSave.setPutCode(locationPathArray[locationPathArray.length - 1]);
        this.workService.saveWork(workToSave);
        return workToSave;
    }

    @RequestMapping(value={"/orcid/work/update/{putCode}"}, method={RequestMethod.POST})
    public Work updateWork(@PathVariable String putCode, @RequestBody String resultString) throws Exception {
        this.log.debug("updateWork: putCode = " + putCode);
        Gson gson = new GsonBuilder().create();
        ResultIdAndWork result = (ResultIdAndWork)gson.fromJson(resultString, ResultIdAndWork.class);
        UserTokens userTokens = this.userTokensService.getUserTokens();
        if (userTokens == null) {
            throw new AuthorizationServiceException("User is not registered");
        }
        String userOrcid = userTokens.getOrcid();
        String userAccessToken = userTokens.getAccessToken();
        String url = this.orcidConfig.getApiURL() + userOrcid + "/work/" + putCode;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json;charset=UTF-8");
        HttpEntity request = new HttpEntity((Object)gson.toJson(result.getWork()), (MultiValueMap)headers);
        this.orcid_log.info("request: " + String.valueOf(request));
        this.orcid_log.info("url: " + url);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            this.orcid_log.error("Updating work response code is: " + String.valueOf(response.getStatusCode()));
            this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
            if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
                throw new NotFoundException("Work to update not found");
            }
            if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new AuthorizationServiceException("You are not allowed to update work");
            }
            if (response.getStatusCode() == HttpStatus.CONFLICT) {
                throw new ConflictException("Work is already saved");
            }
            throw new Exception("Internal server error");
        }
        this.orcid_log.info("Response: " + String.valueOf(response));
        Date date = new Date();
        Work localWork = this.workService.getLocalWorkByPutCode(putCode);
        localWork.setPids(result.getPids());
        localWork.setOpenaireId(result.getOpenaireId());
        localWork.setUpdateDate(date);
        this.workService.saveWork(localWork);
        return localWork;
    }

    @RequestMapping(value={"/orcid/works"}, method={RequestMethod.GET})
    public String getWorksByPutCodes(@RequestParam String put_codes) throws BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, IOException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        this.log.debug("getWorksByPutCodes: put_codes = " + put_codes);
        UserTokens userTokens = this.userTokensService.getUserTokens();
        String userOrcid = userTokens.getOrcid();
        String userAccessToken = userTokens.getAccessToken();
        String url = this.orcidConfig.getApiURL() + userOrcid + "/works/" + put_codes;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "application/json");
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json;charset=UTF-8");
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        this.orcid_log.info("request: " + String.valueOf(request));
        this.orcid_log.info("url: " + url);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            this.orcid_log.error("Getting works response code is: " + String.valueOf(response.getStatusCode()));
            this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
            return null;
        }
        this.orcid_log.info("Response: " + String.valueOf(response));
        return ((String)response.getBody()).toString();
    }

    @RequestMapping(value={"/orcid/work/{putCode}/delete"}, method={RequestMethod.DELETE})
    public String deleteWork(@PathVariable String putCode) throws IOException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        this.log.debug("deleteWork: putCode = " + putCode);
        UserTokens userTokens = this.userTokensService.getUserTokens();
        String userOrcid = userTokens.getOrcid();
        String userAccessToken = userTokens.getAccessToken();
        String url = this.orcidConfig.getApiURL() + userOrcid + "/work/" + putCode;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json;charset=UTF-8");
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        this.orcid_log.info("request: " + String.valueOf(request));
        this.orcid_log.info("url: " + url);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.NO_CONTENT) {
            this.orcid_log.error("Deleting work response code is: " + String.valueOf(response.getStatusCode()));
            this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
            if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
                this.workService.deleteWork(putCode);
                return putCode;
            }
            if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new AuthorizationServiceException("You are not allowed to delete work");
            }
            return null;
        }
        this.orcid_log.info("Response: " + String.valueOf(response));
        this.workService.deleteWork(putCode);
        return putCode;
    }

    @RequestMapping(value={"/orcid/works/delete"}, method={RequestMethod.POST})
    public List<String> deleteWorks(@RequestBody List<String> putCodes) throws IOException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        this.log.debug("deleteWorks: putCodes = " + String.valueOf(putCodes));
        UserTokens userTokens = this.userTokensService.getUserTokens();
        String userOrcid = userTokens.getOrcid();
        String userAccessToken = userTokens.getAccessToken();
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json;charset=UTF-8");
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ArrayList<String> deletedPutCodes = new ArrayList<String>();
        int index = 0;
        for (String putCode : putCodes) {
            String url = this.orcidConfig.getApiURL() + userOrcid + "/work/" + putCode;
            this.orcid_log.info("request: " + String.valueOf(request));
            this.orcid_log.info("url: " + url);
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, request, String.class, new Object[0]);
            if (response.getStatusCode() != HttpStatus.NO_CONTENT) {
                this.orcid_log.error("Deleting work response code is: " + String.valueOf(response.getStatusCode()));
                this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
                if (index == 0 && response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                    throw new AuthorizationServiceException("You are not allowed to delete work");
                }
                if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
                    this.workService.deleteWork(putCode);
                    deletedPutCodes.add(putCode);
                } else {
                    deletedPutCodes.add(null);
                }
            } else {
                this.orcid_log.info("Response: " + String.valueOf(response));
                this.workService.deleteWork(putCode);
                deletedPutCodes.add(putCode);
            }
            ++index;
        }
        return deletedPutCodes;
    }

    @RequestMapping(value={"/orcid/work"}, method={RequestMethod.GET})
    public List<String> getWorksOfResult(@RequestParam String openaireId, @RequestParam(required=false) String[] pids, @RequestParam String orcid) throws BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException, IOException {
        this.log.debug("getWorks: pids = " + String.valueOf(pids) + " - openaireId: " + openaireId + " - orcid = " + orcid);
        List works = this.workService.getWorks(openaireId, pids, orcid);
        String userAccessToken = this.userTokensService.getUserAccessToken(orcid);
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "application/json");
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json;charset=UTF-8");
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ArrayList<String> responseValues = new ArrayList<String>();
        for (Work work : works) {
            String url = this.orcidConfig.getApiURL() + orcid + "/work/" + work.getPutCode();
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
            this.orcid_log.info("request: " + String.valueOf(request));
            this.orcid_log.info("url: " + url);
            ResponseEntity response = restTemplate.exchange(builder.toUriString(), HttpMethod.GET, request, String.class, new Object[0]);
            if (response.getStatusCode() != HttpStatus.OK) {
                this.orcid_log.error("Getting work response code is: " + String.valueOf(response.getStatusCode()));
                this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
                if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
                    this.workService.deleteWork(work.getPutCode());
                }
                responseValues.add(null);
                continue;
            }
            this.orcid_log.info("Response: " + String.valueOf(response));
            responseValues.add(((String)response.getBody()).toString());
        }
        return responseValues;
    }

    @RequestMapping(value={"/local/works"}, method={RequestMethod.GET})
    public List<Work> getMyLocalWorks() {
        this.log.debug("getMyWorks");
        String userOrcid = this.userTokensService.getCurrentUserOrcid();
        List works = this.workService.getLocalWorks(userOrcid);
        return works;
    }
}

