/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.services;

import com.google.gson.Gson;
import eu.dnetlib.uoaorcidservice.dao.UserTokensDAO;
import eu.dnetlib.uoaorcidservice.entities.UserTokens;
import eu.dnetlib.uoaorcidservice.utils.AESUtils;
import eu.dnetlib.uoaorcidservice.utils.RolesUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.stereotype.Service;

@Service
public class UserTokensService {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final UserTokensDAO userTokensDAO;
    private final RolesUtils rolesUtils;

    @Autowired
    public UserTokensService(UserTokensDAO userTokensDAO, RolesUtils rolesUtils) {
        this.userTokensDAO = userTokensDAO;
        this.rolesUtils = rolesUtils;
    }

    public List<UserTokens> getAllUserTokens() {
        return this.userTokensDAO.findAll();
    }

    public UserTokens getUserTokensByAaiId(String aaiId) {
        return (UserTokens)this.userTokensDAO.findByAaiId(aaiId).orElseThrow(() -> new AuthorizationServiceException("User is not registered"));
    }

    public String getUserAccessToken(String orcid) throws BadPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException, IOException {
        this.log.debug("getUserAccessToken: orcid=" + orcid);
        UserTokens userTokens = this.decryptTokens(this.getUserTokensByAaiId(this.rolesUtils.getAaiId()));
        this.log.debug("userTokens.getAccessToken(): " + userTokens.getAccessToken());
        return userTokens.getAccessToken();
    }

    public String getCurrentUserOrcid() {
        this.log.debug("getCurrentUserOrcid");
        UserTokens userTokens = this.getUserTokensByAaiId(this.rolesUtils.getAaiId());
        this.log.debug("userTokens.getOrcidId(): " + userTokens.getOrcid());
        return userTokens.getOrcid();
    }

    public UserTokens getUserTokens() throws BadPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException, IOException {
        this.log.debug("getUserTokens");
        return this.decryptTokens(this.getUserTokensByAaiId(this.rolesUtils.getAaiId()));
    }

    public UserTokens json2UserTokens(String json) {
        this.log.debug("json2UserTokens: " + json);
        if (json == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new StringReader(json));
        Gson gson = new Gson();
        UserTokens userTokens = null;
        try {
            userTokens = (UserTokens)gson.fromJson((Reader)br, UserTokens.class);
        }
        catch (Exception e) {
            this.log.debug("Error in parsing json response. Given json is : " + json, (Throwable)e);
        }
        return userTokens;
    }

    public void saveUserTokens(UserTokens userTokens) throws InvalidKeySpecException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidKeyException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchPaddingException, IOException {
        userTokens.setCreationDate(new Date());
        userTokens.setAaiId(this.rolesUtils.getAaiId());
        userTokens = this.encryptTokens(userTokens);
        this.userTokensDAO.save((Object)userTokens);
    }

    public UserTokens encryptTokens(UserTokens userTokens) throws InvalidKeySpecException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidKeyException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchPaddingException, IOException {
        String cipherText = AESUtils.encryptPasswordBased((String)userTokens.getAccessToken(), (String)userTokens.getAaiId());
        userTokens.setAccessToken(cipherText);
        cipherText = AESUtils.encryptPasswordBased((String)userTokens.getRefreshToken(), (String)userTokens.getAaiId());
        userTokens.setRefreshToken(cipherText);
        return userTokens;
    }

    public UserTokens decryptTokens(UserTokens userTokens) throws InvalidKeySpecException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidKeyException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchPaddingException, IOException {
        if (userTokens == null) {
            return null;
        }
        String token = AESUtils.decryptPasswordBased((String)userTokens.getAccessToken(), (String)userTokens.getAaiId());
        userTokens.setAccessToken(token);
        token = AESUtils.decryptPasswordBased((String)userTokens.getRefreshToken(), (String)userTokens.getAaiId());
        userTokens.setRefreshToken(token);
        return userTokens;
    }

    public UserTokens getUserTokensByAai(String aaiId) throws BadPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException, IOException {
        this.log.debug("getUserTokens");
        UserTokens userTokens = this.getUserTokensByAaiId(aaiId);
        return this.decryptTokens(userTokens);
    }

    public UserTokens getEncryptedUserTokensByAai(String aaiId) {
        this.log.debug("getEncryptedUserTokensByAai");
        return this.getUserTokensByAaiId(aaiId);
    }
}

