/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.context.properties.ConfigurationProperties;

/*
 * Exception performing whole class analysis ignored.
 */
@ConfigurationProperties(value="orcid-service.encryption")
public class AESUtils {
    private static final Logger log = LogManager.getLogger(AESUtils.class);
    private static String password;

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        AESUtils.password = password;
    }

    public static SecretKey generateKey(int n) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(n);
        SecretKey key = keyGenerator.generateKey();
        return key;
    }

    public static SecretKey getKeyFromPassword(String password, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 65536, 256);
        SecretKeySpec secret = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        return secret;
    }

    public static IvParameterSpec generateIv() {
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        return new IvParameterSpec(iv);
    }

    public static String encryptPasswordBased(String plainText, String salt) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException, InvalidKeySpecException {
        IvParameterSpec iv = AESUtils.generateIv();
        SecretKey key = AESUtils.getKeyFromPassword((String)password, (String)salt);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)key, iv);
        log.debug("password: " + password);
        log.debug("salt: " + salt);
        log.debug("encrypt: " + plainText);
        log.debug("key: " + String.valueOf(key));
        log.debug("encrypted: |" + Base64.getEncoder().encodeToString(cipher.doFinal(plainText.getBytes())) + "|");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(iv.getIV());
        outputStream.write(cipher.doFinal(plainText.getBytes()));
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    public static String decryptPasswordBased(String cipherTextStr, String salt) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException {
        SecretKey key = AESUtils.getKeyFromPassword((String)password, (String)salt);
        byte[] ciphertext = Base64.getDecoder().decode(cipherTextStr);
        byte[] iv = Arrays.copyOfRange(ciphertext, 0, 16);
        byte[] ct = Arrays.copyOfRange(ciphertext, 16, ciphertext.length);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)key, new IvParameterSpec(iv));
        log.debug("decrypt: |" + String.valueOf(ct) + "|");
        log.debug("key: " + String.valueOf(key));
        log.debug("decrypted: " + new String(cipher.doFinal(ct)));
        return new String(cipher.doFinal(ct));
    }
}

