/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.controllers;

import eu.dnetlib.uoaorcidservice.configuration.properties.OrcidConfig;
import eu.dnetlib.uoaorcidservice.entities.UserTokens;
import eu.dnetlib.uoaorcidservice.responses.SingleValueWrapperResponse;
import eu.dnetlib.uoaorcidservice.services.UserTokensService;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@RestController
@PreAuthorize(value="isAuthenticated()")
public class UserTokensController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Logger orcid_log = LogManager.getLogger((String)("ORCID-" + this.getClass().getName()));
    @Autowired
    private OrcidConfig orcidConfig;
    @Autowired
    private UserTokensService userTokensService;

    @Autowired
    public UserTokensController(OrcidConfig orcidConfig, UserTokensService userTokensService) {
        this.orcidConfig = orcidConfig;
        this.userTokensService = userTokensService;
    }

    @RequestMapping(value={"/local/orcidId"}, method={RequestMethod.GET})
    public ResponseEntity<SingleValueWrapperResponse<String>> getUserOrcidId() throws BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, IOException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        UserTokens userTokens = this.userTokensService.getUserTokens();
        String userOrcid = userTokens.getOrcid();
        return ResponseEntity.ok((Object)new SingleValueWrapperResponse((Object)userOrcid));
    }

    @RequestMapping(value={"/orcid/token/save"}, method={RequestMethod.GET})
    public ResponseEntity<SingleValueWrapperResponse<Boolean>> saveUserTokens(@RequestParam String code) throws BadPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException, IOException {
        this.log.debug("saveUserTokens: code=" + code);
        String url = this.orcidConfig.getTokenURL();
        String clientId = this.orcidConfig.getClientId();
        String clientSecret = this.orcidConfig.getClientSecret();
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-www-form-urlencoded");
        headers.add("Accept", "application/json");
        String inputString = "client_id=" + clientId + "&client_secret=" + clientSecret + "&grant_type=authorization_code&code=" + code;
        HttpEntity request = new HttpEntity((Object)inputString, (MultiValueMap)headers);
        this.orcid_log.info("url: " + url);
        this.orcid_log.info("request: " + String.valueOf(request));
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            this.orcid_log.error("User tokens response code is: " + String.valueOf(response.getStatusCode()));
            this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
            return ResponseEntity.ok((Object)new SingleValueWrapperResponse((Object)false));
        }
        this.orcid_log.info("Response: " + String.valueOf(response));
        UserTokens userTokens = this.userTokensService.json2UserTokens(((String)response.getBody()).toString());
        this.userTokensService.saveUserTokens(userTokens);
        return ResponseEntity.ok((Object)new SingleValueWrapperResponse((Object)true));
    }

    @RequestMapping(value={"/orcid/personal-details"}, method={RequestMethod.GET})
    public ResponseEntity<String> getPersonalDetailsFromOrcid() throws Exception {
        this.log.debug("getPersonalDetailsFromOrcid");
        UserTokens userTokens = this.userTokensService.getUserTokens();
        String userOrcid = userTokens.getOrcid();
        String userAccessToken = userTokens.getAccessToken();
        String url = this.orcidConfig.getApiURL() + userOrcid + "/personal-details";
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "application/json");
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json");
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        this.orcid_log.info("request: " + String.valueOf(request));
        this.orcid_log.info("url: " + url);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            this.orcid_log.error("Getting user details response code is: " + String.valueOf(response.getStatusCode()));
            this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
            if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new AuthorizationServiceException("You are not allowed to get personal details");
            }
            throw new Exception("Internal server error");
        }
        this.orcid_log.info("response: " + String.valueOf(response));
        return ResponseEntity.ok((Object)((String)response.getBody()));
    }
}

