/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.dao.customDAOs;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.DateOperators;
import org.springframework.stereotype.Repository;

@Repository
public class MongoDBUserTokensDAOCustom {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final MongoTemplate mongoTemplate;

    @Autowired
    public MongoDBUserTokensDAOCustom(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public List<Object> newUsersPerMonth() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.project((String[])new String[]{"orcid"}).and((AggregationExpression)DateOperators.dateOf((String)"creationDate").month()).as("month").and((AggregationExpression)DateOperators.dateOf((String)"creationDate").year()).as("year"), Aggregation.group((String[])new String[]{"month", "year", "orcid"}).count().as("orcid_works"), Aggregation.group((String[])new String[]{"month", "year"}).count().as("works"), Aggregation.project((String[])new String[]{"works"}).andInclude(new String[]{"month", "year"})});
        AggregationResults results = this.mongoTemplate.aggregate(agg.withOptions(Aggregation.newAggregationOptions().cursor(new Document()).build()), "userTokens", Object.class);
        return this.mapResults(results);
    }

    public List<Object> newUsersPerYear() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.project((String[])new String[]{"orcid"}).and((AggregationExpression)DateOperators.dateOf((String)"creationDate").year()).as("year"), Aggregation.group((String[])new String[]{"year", "orcid"}).count().as("orcid_works"), Aggregation.group((String[])new String[]{"year"}).count().as("works"), Aggregation.project((String[])new String[]{"works"}).andInclude(new String[]{"year"})});
        AggregationResults results = this.mongoTemplate.aggregate(agg.withOptions(Aggregation.newAggregationOptions().cursor(new Document()).build()), "userTokens", Object.class);
        return this.mapResults(results);
    }

    public List<Object> tokensPerOrcid() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"orcid"}).count().as("tokens"), Aggregation.project((String[])new String[]{"tokens"}).andInclude(new String[]{"orcid"}), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"tokens"})});
        AggregationResults results = this.mongoTemplate.aggregate(agg.withOptions(Aggregation.newAggregationOptions().cursor(new Document()).build()), "userTokens", Object.class);
        return this.mapResults(results);
    }

    public List<Object> totalUniqueUsers() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"orcid"}), Aggregation.count().as("users"), Aggregation.project((String[])new String[]{"users"})});
        AggregationResults results = this.mongoTemplate.aggregate(agg.withOptions(Aggregation.newAggregationOptions().cursor(new Document()).build()), "userTokens", Object.class);
        return this.mapResults(results);
    }

    public List<Object> mapResults(AggregationResults<Object> results) {
        Map cursorResults;
        List mappedResult = results.getMappedResults();
        Document rawResults = results.getRawResults();
        if (rawResults.containsKey((Object)"cursor") && mappedResult.isEmpty() && (cursorResults = (Map)rawResults.get((Object)"cursor")) != null && cursorResults.containsKey("firstBatch")) {
            mappedResult = (List)cursorResults.get("firstBatch");
        }
        return mappedResult;
    }
}

