/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.services;

import eu.dnetlib.uoaorcidservice.dao.MetricsDAO;
import eu.dnetlib.uoaorcidservice.dao.customDAOs.MongoDBUserTokensDAOCustom;
import eu.dnetlib.uoaorcidservice.dao.customDAOs.MongoDBWorkDAOCustom;
import eu.dnetlib.uoaorcidservice.entities.Metrics;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@EnableScheduling
@Service
public class MetricsService {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final MongoDBWorkDAOCustom workDAO;
    private final MongoDBUserTokensDAOCustom userTokensDAO;
    private final MetricsDAO metricsDAO;

    @Autowired
    public MetricsService(MongoDBWorkDAOCustom workDAO, MongoDBUserTokensDAOCustom userTokensDAO, MetricsDAO metricsDAO) {
        this.workDAO = workDAO;
        this.userTokensDAO = userTokensDAO;
        this.metricsDAO = metricsDAO;
    }

    public List<Object> countWorksPerDashboard() {
        return this.workDAO.worksPerDashboard();
    }

    public List<Object> countWorksPerYear() {
        return this.workDAO.worksPerYear();
    }

    public List<Object> countWorksPerYearAndMonth() {
        return this.workDAO.worksPerYearAndMonth();
    }

    public List<Object> countWorksPerOrcid() {
        return this.workDAO.worksPerOrcid();
    }

    public List<Object> countUniqueUsersWithLinksPerMonth() {
        return this.workDAO.uniqueUsersWithLinksPerMonth();
    }

    public List<Object> countUniqueUsersWithLinksPerYear() {
        return this.workDAO.uniqueUsersWithLinksPerYear();
    }

    public List<Object> countNewUsersPerMonth() {
        return this.userTokensDAO.newUsersPerMonth();
    }

    public List<Object> countNewUsersPerYear() {
        return this.userTokensDAO.newUsersPerYear();
    }

    public List<Object> countTokensPerOrcid() {
        return this.userTokensDAO.tokensPerOrcid();
    }

    public List<Object> countTotalUniqueUsers() {
        return this.userTokensDAO.totalUniqueUsers();
    }

    public List<Object> countTotalWorks() {
        return this.workDAO.totalWorks();
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void calculateMetrics() {
        this.log.info("Calculate metrics and add them in DB");
        Metrics metrics = new Metrics();
        metrics.setId("current");
        List totalWorks = this.countTotalWorks();
        if (totalWorks == null || totalWorks.get(0) == null) {
            metrics.setTotal_works(-1);
            return;
        }
        HashMap works = (HashMap)totalWorks.get(0);
        metrics.setTotal_works(((Integer)works.get("works")).intValue());
        List totalUsers = this.countTotalUniqueUsers();
        if (totalUsers == null || totalUsers.get(0) == null) {
            metrics.setTotal_users(-1);
            return;
        }
        HashMap users = (HashMap)totalUsers.get(0);
        metrics.setTotal_users(((Integer)users.get("users")).intValue());
        List works_per_dashboard = this.countWorksPerDashboard();
        for (Object dashboardWorksObj : works_per_dashboard) {
            HashMap dashboardWorks = (HashMap)dashboardWorksObj;
            String[] dashboard_elements = ((String)dashboardWorks.get("dashboard")).split("_", 2);
            dashboardWorks.put("environment", dashboard_elements[0]);
            dashboardWorks.put("dashboard", dashboard_elements[1]);
        }
        metrics.setWorks_per_dashboard(works_per_dashboard);
        metrics.setDate(new Date());
        this.metricsDAO.save((Object)metrics);
    }

    public String getMetrics() {
        Optional metrics_optional = this.metricsDAO.findById((Object)"current");
        if (!metrics_optional.isPresent()) {
            return null;
        }
        Metrics metrics = (Metrics)metrics_optional.get();
        Object response = "";
        response = (String)response + "# TYPE orcid_users gauge\n";
        response = (String)response + "orcid_users " + metrics.getTotal_users() + "\n";
        if (metrics.getWorks_per_dashboard() != null) {
            HashMap<String, Integer> worksPerDashboard = new HashMap<String, Integer>();
            for (Object e : metrics.getWorks_per_dashboard()) {
                HashMap dashboardWorks = (HashMap)e;
                if (worksPerDashboard.containsKey(dashboardWorks.get("dashboard"))) {
                    int worksSoFar = (Integer)worksPerDashboard.get(dashboardWorks.get("dashboard"));
                    worksPerDashboard.put((String)dashboardWorks.get("dashboard"), (Integer)dashboardWorks.get("works") + worksSoFar);
                    continue;
                }
                worksPerDashboard.put((String)dashboardWorks.get("dashboard"), (Integer)dashboardWorks.get("works"));
            }
            response = (String)response + "# TYPE orcid_works gauge\n";
            for (Map.Entry entry : worksPerDashboard.entrySet()) {
                response = (String)response + "orcid_works{portal=\"" + (String)entry.getKey() + "\"} " + String.valueOf(entry.getValue()) + "\n";
            }
        }
        Instant instant = metrics.getDate().toInstant();
        response = (String)response + "orcid_last_metrics_updater_run_timestamp_seconds " + instant.getEpochSecond() + "\n";
        return response;
    }
}

