/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.services;

import eu.dnetlib.uoaorcidservice.dao.WorkDAO;
import eu.dnetlib.uoaorcidservice.entities.Work;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkService {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final WorkDAO workDAO;

    @Autowired
    public WorkService(WorkDAO workDAO) {
        this.workDAO = workDAO;
    }

    public List<Work> getAllWorks() {
        return this.workDAO.findAll();
    }

    public List<Work> getWorks(String openaireId, String[] pids, String orcid) {
        if (pids != null) {
            return this.workDAO.findByPidsInAndOrcid(pids, orcid);
        }
        return this.workDAO.findByOpenaireIdAndOrcid(openaireId, orcid);
    }

    public void saveWork(Work work) {
        this.log.debug("Save in DB work with pids: " + Arrays.toString(work.getPids()) + " & openaireId: " + work.getOpenaireId() + "- for ORCID iD: " + work.getOrcid());
        this.workDAO.save((Object)work);
    }

    public void deleteWork(String putCode) {
        this.log.debug("Delete from DB work with putCode: " + putCode);
        this.workDAO.deleteByPutCode(putCode);
    }

    public List<Work> getLocalWorks(String orcid) {
        return this.workDAO.findByOrcidOrderByCreationDateDesc(orcid);
    }

    public Work getLocalWorkByPutCode(String putCode) {
        return this.workDAO.findByPutCode(putCode).orElse(null);
    }
}

