/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.controllers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.ConflictException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoaorcidservice.configuration.properties.OrcidConfig;
import eu.dnetlib.uoaorcidservice.entities.UserTokens;
import eu.dnetlib.uoaorcidservice.responses.SingleValueWrapperResponse;
import eu.dnetlib.uoaorcidservice.services.UserTokensService;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@RestController
@PreAuthorize(value="isAuthenticated()")
public class ActivitiesController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Logger orcid_log = LogManager.getLogger((String)("ORCID-" + this.getClass().getName()));
    private final OrcidConfig orcidConfig;
    private final UserTokensService userTokensService;

    @Autowired
    public ActivitiesController(OrcidConfig orcidConfig, UserTokensService userTokensService) {
        this.orcidConfig = orcidConfig;
        this.userTokensService = userTokensService;
    }

    @RequestMapping(value={"/orcid/{activityType}/{putCode}"}, method={RequestMethod.GET})
    public String getActivity(@PathVariable String activityType, @PathVariable String putCode) throws Exception {
        this.log.debug("getActivity(" + activityType + "): putCode = " + putCode);
        UserTokens userTokens = this.userTokensService.getUserTokens();
        String userOrcid = userTokens.getOrcid();
        String userAccessToken = userTokens.getAccessToken();
        String url = this.orcidConfig.getApiURL() + userOrcid + "/" + activityType + "/" + putCode;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json;charset=UTF-8");
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        this.orcid_log.info("request: " + String.valueOf(request));
        this.orcid_log.info("url: " + url);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            this.orcid_log.error("Getting activity response code is: " + String.valueOf(response.getStatusCode()));
            this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
            if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
                throw new Exception("Activity not found");
            }
            throw new Exception("Internal server error");
        }
        return (String)response.getBody();
    }

    @RequestMapping(value={"/orcid/{activityType}/save"}, method={RequestMethod.POST})
    public ResponseEntity<SingleValueWrapperResponse<String>> saveActivity(@PathVariable String activityType, @RequestBody String resultString) throws Exception {
        this.log.debug("saveActivity (" + activityType + "): result = " + resultString);
        UserTokens userTokens = this.userTokensService.getUserTokens();
        String userOrcid = userTokens.getOrcid();
        String userAccessToken = userTokens.getAccessToken();
        String url = this.orcidConfig.getApiURL() + userOrcid + "/" + activityType;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json;charset=UTF-8");
        HttpEntity request = new HttpEntity((Object)resultString, (MultiValueMap)headers);
        this.orcid_log.info("request: " + String.valueOf(request));
        this.orcid_log.info("url: " + url);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.CREATED) {
            this.orcid_log.error("Saving activity response code is: " + String.valueOf(response.getStatusCode()));
            this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
            if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new AuthorizationServiceException("You are not allowed to save activity");
            }
            if (response.getStatusCode() == HttpStatus.CONFLICT) {
                throw new ConflictException("Activity is already saved");
            }
            throw new Exception("Internal server error");
        }
        this.orcid_log.info("Response: " + String.valueOf(response));
        HttpHeaders responseHeaders = response.getHeaders();
        String locationPath = responseHeaders.getLocation().toString();
        String[] locationPathArray = locationPath.split("/");
        return ResponseEntity.ok((Object)new SingleValueWrapperResponse((Object)locationPathArray[locationPathArray.length - 1]));
    }

    @RequestMapping(value={"/orcid/{activityType}/update/{putCode}"}, method={RequestMethod.POST})
    public ResponseEntity<SingleValueWrapperResponse<String>> updateActivity(@PathVariable String activityType, @PathVariable String putCode, @RequestBody String resultString) throws Exception {
        this.log.debug("updateActivity(" + activityType + "): putCode = " + putCode);
        Gson gson = new GsonBuilder().create();
        UserTokens userTokens = this.userTokensService.getUserTokens();
        if (userTokens == null) {
            throw new AuthorizationServiceException("User is not registered");
        }
        String userOrcid = userTokens.getOrcid();
        String userAccessToken = userTokens.getAccessToken();
        String url = this.orcidConfig.getApiURL() + userOrcid + "/" + activityType + "/" + putCode;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json;charset=UTF-8");
        HttpEntity request = new HttpEntity((Object)resultString, (MultiValueMap)headers);
        this.orcid_log.info("request: " + String.valueOf(request));
        this.orcid_log.info("url: " + url);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            this.orcid_log.error("Updating activity response code is: " + String.valueOf(response.getStatusCode()));
            this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
            if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
                throw new NotFoundException("Activity to update not found");
            }
            if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new AuthorizationServiceException("You are not allowed to update activity");
            }
            if (response.getStatusCode() == HttpStatus.CONFLICT) {
                throw new ConflictException("Activity is already saved");
            }
            throw new Exception("Internal server error");
        }
        this.orcid_log.info("Response: " + String.valueOf(response));
        return ResponseEntity.ok((Object)new SingleValueWrapperResponse((Object)putCode));
    }

    @RequestMapping(value={"/orcid/{activityType}/{putCode}/delete"}, method={RequestMethod.DELETE})
    public ResponseEntity<SingleValueWrapperResponse<String>> deleteActivity(@PathVariable String activityType, @PathVariable String putCode) throws IOException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        this.log.debug("deleteActivity(" + activityType + "): putCode = " + putCode);
        UserTokens userTokens = this.userTokensService.getUserTokens();
        String userOrcid = userTokens.getOrcid();
        String userAccessToken = userTokens.getAccessToken();
        String url = this.orcidConfig.getApiURL() + userOrcid + "/" + activityType + "/" + putCode;
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + userAccessToken);
        headers.add("Content-Type", "application/orcid+json;charset=UTF-8");
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        this.orcid_log.info("request: " + String.valueOf(request));
        this.orcid_log.info("url: " + url);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.NO_CONTENT) {
            this.orcid_log.error("Deleting activity response code is: " + String.valueOf(response.getStatusCode()));
            this.orcid_log.error("Unexpected Response: " + (String)response.getBody());
            if (response.getStatusCode() == HttpStatus.NOT_FOUND) {
                return ResponseEntity.ok((Object)new SingleValueWrapperResponse((Object)putCode));
            }
            if (response.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                throw new AuthorizationServiceException("You are not allowed to delete activity");
            }
            return ResponseEntity.ok((Object)new SingleValueWrapperResponse(null));
        }
        this.orcid_log.info("Response: " + String.valueOf(response));
        return ResponseEntity.ok((Object)new SingleValueWrapperResponse((Object)putCode));
    }
}

