/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.controllers;

import eu.dnetlib.uoaorcidservice.responses.ExceptionResponse;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
@RequestMapping(value={"/error"})
public class SimpleErrorController
implements ErrorController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Logger orcid_log = LogManager.getLogger((String)("ORCID-" + this.getClass().getName()));
    private final ErrorAttributes errorAttributes;

    @Autowired
    public SimpleErrorController(ErrorAttributes errorAttributes) {
        Assert.notNull((Object)errorAttributes, (String)"ErrorAttributes must not be null");
        this.errorAttributes = errorAttributes;
    }

    public String getErrorPath() {
        return "/error";
    }

    @RequestMapping
    public ResponseEntity<ExceptionResponse> error(WebRequest request) {
        Map body = this.getErrorAttributes(request, this.getTraceParameter(request));
        String path = (String)body.get("path");
        if (path.contains("/uoa-orcid-service/orcid")) {
            this.orcid_log.error((Object)body);
        } else {
            this.log.error((Object)body);
        }
        Integer status = (Integer)body.get("status");
        HttpStatus statusCode = HttpStatus.INTERNAL_SERVER_ERROR;
        if (status != null) {
            statusCode = HttpStatus.valueOf((int)status);
        }
        ExceptionResponse response = new ExceptionResponse();
        response.setErrorCode((String)body.get("error"));
        response.setErrorMessage((String)body.get("exception"));
        response.setErrors((String)body.get("message"));
        response.setStatus(statusCode);
        return new ResponseEntity((Object)response, (HttpStatusCode)statusCode);
    }

    private boolean getTraceParameter(WebRequest request) {
        return "true".equalsIgnoreCase(request.getParameter("trace"));
    }

    private Map<String, Object> getErrorAttributes(WebRequest request, boolean includeStackTrace) {
        ErrorAttributeOptions options = includeStackTrace ? ErrorAttributeOptions.of((ErrorAttributeOptions.Include[])new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.STACK_TRACE}) : ErrorAttributeOptions.defaults();
        return this.errorAttributes.getErrorAttributes(request, options);
    }
}

