/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaorcidservice.services;

import eu.dnetlib.uoaorcidservice.configuration.GlobalVars;
import eu.dnetlib.uoaorcidservice.configuration.properties.MongoConfig;
import eu.dnetlib.uoaorcidservice.configuration.properties.OrcidConfig;
import eu.dnetlib.uoaorcidservice.utils.AESUtils;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeployService {
    private final MongoConfig mongoConfig;
    private final OrcidConfig orcidConfig;
    private final GlobalVars globalVars;
    private final AESUtils aesUtils;

    @Autowired
    public DeployService(MongoConfig mongoConfig, OrcidConfig orcidConfig, GlobalVars globalVars, AESUtils aesUtils) {
        this.mongoConfig = mongoConfig;
        this.orcidConfig = orcidConfig;
        this.globalVars = globalVars;
        this.aesUtils = aesUtils;
    }

    @PostConstruct
    public void checkProperties() {
        if (this.mongoConfig.getHost() == null || this.mongoConfig.getHost().isEmpty()) {
            throw new RuntimeException("orcid-service.mongodb.host is missing!");
        }
        if (this.mongoConfig.getDatabase() == null || this.mongoConfig.getDatabase().isEmpty()) {
            throw new RuntimeException("orcid-service.mongodb.database is missing!");
        }
        if (this.orcidConfig.getApiURL() == null || this.orcidConfig.getApiURL().isEmpty()) {
            throw new RuntimeException("orcid-service.orcid.api-url is missing!");
        }
        if (this.orcidConfig.getTokenURL() == null || this.orcidConfig.getTokenURL().isEmpty()) {
            throw new RuntimeException("orcid-service.orcid.token-url is missing!");
        }
        if (this.orcidConfig.getClientId() == null || this.orcidConfig.getClientId().isEmpty()) {
            throw new RuntimeException("orcid-service.orcid.client-id is missing!");
        }
        if (this.orcidConfig.getClientSecret() == null || this.orcidConfig.getClientSecret().isEmpty()) {
            throw new RuntimeException("orcid-service.orcid.client-secret is missing!");
        }
        if (this.aesUtils.getPassword() == null || this.aesUtils.getPassword().isEmpty()) {
            throw new RuntimeException("orcid-service.encryption.password is missing!");
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("orcid-service.mongodb.database", this.mongoConfig.getDatabase());
        response.put("orcid-service.mongodb.host", this.mongoConfig.getHost());
        response.put("orcid-service.mongodb.port", "" + this.mongoConfig.getPort());
        response.put("orcid-service.mongodb.username", this.mongoConfig.getUsername() == null ? null : "[unexposed value]");
        response.put("orcid-service.mongodb.password", this.mongoConfig.getPassword() == null ? null : "[unexposed value]");
        response.put("orcid-service.orcid.apiURL", this.orcidConfig.getApiURL());
        response.put("orcid-service.orcid.tokenURL", this.orcidConfig.getTokenURL());
        response.put("orcid-service.orcid.clientId", this.orcidConfig.getClientId() == null ? null : "[unexposed value]");
        response.put("orcid-service.orcid.clientSecret", this.orcidConfig.getClientSecret() == null ? null : "[unexposed value]");
        response.put("orcid-service.encryption.password", this.aesUtils.getPassword() == null ? null : "[unexposed value]");
        response.put("Date of deploy", GlobalVars.date.toString());
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            response.put("Version", this.globalVars.getVersion());
        }
        return response;
    }
}

