/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.controller;

import eu.dnet.researcher.dto.ImpactDTO;
import eu.dnet.researcher.postgresql.ImpactCategory;
import eu.dnet.researcher.postgresql.ImpactWork;
import eu.dnet.researcher.services.ImpactCategoryService;
import eu.dnet.researcher.services.ImpactWorkService;
import eu.dnet.researcher.utils.ImpactHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/impact"})
public class ImpactController {
    @Autowired
    private ImpactWorkService impactWorkService;
    @Autowired
    private ImpactCategoryService impactCategoryService;

    @GetMapping(value={"/statistics/{researcherId}"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#researcherId)) : true")
    public ResponseEntity<Map<Long, Number>> getImpactStatistics(@PathVariable Long researcherId) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        map.put(ImpactHelper.SOCIETAL, this.impactWorkService.findImpactWorksByResearcherIdAndActivityConfiguration(researcherId, ImpactHelper.SOCIETAL).size());
        map.put(ImpactHelper.ECONOMICAL, this.impactWorkService.findImpactWorksByResearcherIdAndActivityConfiguration(researcherId, ImpactHelper.ECONOMICAL).size());
        return ResponseEntity.ok(map);
    }

    @PostMapping(value={"/initialize/{researcherId}"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#researcherId)) : true")
    public ResponseEntity<String> createWork(@PathVariable Long researcherId) {
        return ResponseEntity.ok((Object)this.impactCategoryService.initializeCategories(researcherId));
    }

    @PostMapping(value={"/save"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#impactWork.researcherId)) : true")
    public ResponseEntity<List<ImpactDTO>> createWork(@RequestBody ImpactWork impactWork) {
        impactWork.setResearcherId(impactWork.getResearcherId());
        this.impactWorkService.save(impactWork);
        return ResponseEntity.ok((Object)this.impactWorkService.findByResearcherIdAndActivityConfiguration(impactWork.getResearcherId(), impactWork.getActivityConfiguration()));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<List<ImpactDTO>> delete(@PathVariable Long id) {
        ImpactWork work = this.impactWorkService.findById(id);
        this.impactWorkService.deleteById(id);
        return ResponseEntity.ok((Object)this.impactWorkService.findByResearcherIdAndActivityConfiguration(work.getResearcherId(), work.getActivityConfiguration()));
    }

    @PostMapping(value={"/category/save"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#impactWork.researcherId)) : true")
    public ResponseEntity<List<ImpactDTO>> createCategory(@RequestBody ImpactCategory impactCategory) {
        this.impactCategoryService.save(impactCategory);
        return ResponseEntity.ok((Object)this.impactWorkService.findByResearcherIdAndActivityConfiguration(impactCategory.getResearcherId(), impactCategory.getActivityConfiguration()));
    }

    @DeleteMapping(value={"/category/{id}"})
    public ResponseEntity<List<ImpactDTO>> deleteCategory(@PathVariable Long id) {
        ImpactCategory category = this.impactCategoryService.findById(id);
        this.impactCategoryService.deleteByIdWithSubCategoriesAndWorks(id);
        return ResponseEntity.ok((Object)this.impactWorkService.findByResearcherIdAndActivityConfiguration(category.getResearcherId(), category.getActivityConfiguration()));
    }

    @GetMapping(value={"/{activityConfiguration}/{researcherId}"})
    public ResponseEntity<List<ImpactDTO>> getImpactByActivityConfiguratio(@PathVariable Long activityConfiguration, @PathVariable Long researcherId) {
        return ResponseEntity.ok((Object)this.impactWorkService.findByResearcherIdAndActivityConfiguration(researcherId, activityConfiguration));
    }
}

