/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.security;

import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.repositories.ResearcherProfileRepository;
import jakarta.persistence.EntityNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.stereotype.Service;

@Service(value="ORCID")
public class CheckORCIDService {
    private static final String ORCID_LINK = "https://orcid.org/";
    @Autowired
    ResearcherProfileRepository researcherProfileRepository;

    public boolean checkORCID(String orcid) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)authentication;
            DefaultOidcUser user = (DefaultOidcUser)token.getPrincipal();
            return user.getClaim("orcid") != null && user.getClaim("orcid").toString().replace(ORCID_LINK, "").equals(orcid);
        }
        return false;
    }

    public boolean checkOrcidByResearcherId(Long researcherId) {
        ResearcherProfile researcherProfile = (ResearcherProfile)this.researcherProfileRepository.findById((Object)researcherId).orElseThrow(() -> new EntityNotFoundException("Profile with " + researcherId + "not found"));
        return this.checkORCID(researcherProfile.getOrcid());
    }
}

