/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.utils;

import eu.dnet.researcher.dto.ImpactDTO;
import eu.dnet.researcher.postgresql.ImpactCategory;
import eu.dnet.researcher.postgresql.ImpactWork;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImpactHelper {
    public static final Long SOCIETAL = 21L;
    public static final Long ECONOMICAL = 19L;

    public static Boolean validateImpactType(String impactType) {
        if (List.of(SOCIETAL, ECONOMICAL).indexOf(impactType) != -1) {
            return true;
        }
        return false;
    }

    public static Map<String, List<String>> initializeSocietalMap() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        map.put("Contribution to policies", List.of("Drafting and developing policies", "Reviewing policies", "Implementing policies"));
        map.put("Collaboration and engagement with the public", List.of("Public consultations", "Public awareness campaigns", "Public reports & press releases"));
        map.put("Contribution to SDGs", List.of("Environmental Sustainability", "Economic Growth & Employment", "Social Impact & Well-being", "Partnerships & Global Collaboration"));
        map.put("Technological advancements", List.of("AI & Machine learning", "Data Science & Analytics", "Green & Sustainable Tech", "Engineering & Manufacturing", "Healthcare & Biotech"));
        map.put("Uptake in citizen science", List.of("Environmental / Climate conservation", "Public health & Epidemiology", "Cultural Heritage & Archaeology", "Resource Conservation & Management"));
        map.put("Uptake in education", List.of("Conducted workshops and training sessions", "Design of educational programs", "Creation of educational materials", "E-learning adoption "));
        map.put("Promote diversity, equity, and Inclusion (DEI)) ", List.of("Design a gender equality programOrganized DEI workshops", "AI ethics framework", "Creation of synergies promoting DEI"));
        map.put("Volunteering", List.of("International & Humanitarian Work", "Community volunteering", "Healthcare volunteering", "Environmental volunteering"));
        return map;
    }

    public static Map<String, List<String>> initializeEconomicalMap() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        map.put("Innovation outputs", List.of("Patents", "TRL", "New products and services"));
        map.put("Science - industry collaborations", List.of("Funds", "Products"));
        map.put("Economic growth of companies", List.of("Technology transfer to commercial vector", "Start-ups", "Spin off"));
        map.put("Attracting Foreign Direct Investment (FDI)", List.of());
        return map;
    }

    public static List<ImpactCategory> initializeImpactCategories(Long researcherId) {
        List list = ImpactHelper.initializeImpactCategoriesByImpactType((Long)SOCIETAL, (Map)ImpactHelper.initializeSocietalMap(), (Long)researcherId);
        list.addAll(ImpactHelper.initializeImpactCategoriesByImpactType((Long)ECONOMICAL, (Map)ImpactHelper.initializeEconomicalMap(), (Long)researcherId));
        return list;
    }

    private static List<ImpactCategory> initializeImpactCategoriesByImpactType(Long activityConfiguration, Map<String, List<String>> map, Long researcherId) {
        ArrayList<ImpactCategory> list = new ArrayList<ImpactCategory>();
        map.keySet().forEach(type -> {
            ImpactCategory level1 = new ImpactCategory(null, researcherId, activityConfiguration, type, null, null, null);
            list.add(level1);
            ((List)map.get(type)).forEach(subType -> {
                ImpactCategory level2 = new ImpactCategory(null, researcherId, activityConfiguration, type, subType, null, null);
                list.add(level2);
            });
        });
        return list;
    }

    public static List<ImpactDTO> addImpactCategories(List<ImpactDTO> impact, List<ImpactCategory> categories) {
        ArrayList<ImpactDTO> newLevels1 = new ArrayList<ImpactDTO>();
        block0: for (ImpactCategory category : categories) {
            Boolean foundLevel1 = false;
            for (ImpactDTO level1 : impact) {
                if (!category.getActivityConfiguration().equals(level1.getActivityConfiguration()) || !category.getCategory().equals(level1.getCategory()) || category.getSubCategory() == null && !category.getSubCategory().isEmpty()) continue;
                foundLevel1 = true;
                level1.getChildren().add(new ImpactDTO(category.getId(), category.getActivityConfiguration(), category.getCategory(), category.getSubCategory(), Integer.valueOf(0), new ArrayList(), null));
                break;
            }
            if (foundLevel1.booleanValue()) continue;
            if (category.getSubCategory() == null || category.getSubCategory().isEmpty()) {
                newLevels1.add(new ImpactDTO(category.getId(), category.getActivityConfiguration(), category.getCategory(), null, Integer.valueOf(0), new ArrayList(), null));
                continue;
            }
            for (ImpactDTO level1 : newLevels1) {
                if (!category.getActivityConfiguration().equals(level1.getActivityConfiguration()) || !category.getCategory().equals(level1.getCategory()) || category.getSubCategory() == null) continue;
                level1.getChildren().add(new ImpactDTO(category.getId(), category.getActivityConfiguration(), category.getCategory(), category.getSubCategory(), Integer.valueOf(0), null, new ArrayList()));
                continue block0;
            }
        }
        if (newLevels1.size() > 0) {
            impact.addAll(newLevels1);
        }
        return impact;
    }

    public static List<ImpactDTO> addImpactWorks(List<ImpactDTO> impact, List<ImpactWork> impactWorks) {
        block0: for (ImpactWork work : impactWorks) {
            for (ImpactDTO level1 : impact) {
                if (!work.getActivityConfiguration().equals(level1.getActivityConfiguration()) || !work.getCategory().equals(level1.getCategory())) continue;
                for (ImpactDTO level2 : level1.getChildren()) {
                    if (!work.getSubCategory().equals(level2.getSubCategory())) continue;
                    level1.setCountWorks(Integer.valueOf(level1.getCountWorks() + 1));
                    level2.getImpactWorks().add(work);
                    level2.setCountWorks(Integer.valueOf(level2.getCountWorks() + 1));
                    continue block0;
                }
                continue block0;
            }
        }
        return impact;
    }
}

