/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.controller;

import eu.dnet.researcher.dto.ActivityDTO;
import eu.dnet.researcher.services.ActivityService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activities"})
public class ActivityController {
    @Autowired
    private ActivityService activityService;

    @PostMapping(value={"/create"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#activityDTO.researcherId)) : true")
    public ResponseEntity<ActivityDTO> createActivity(@RequestBody ActivityDTO activityDTO) {
        ActivityDTO savedActivity = this.activityService.save(activityDTO);
        return ResponseEntity.ok((Object)savedActivity);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ActivityDTO> getActivity(@PathVariable Long id) {
        ActivityDTO savedActivity = this.activityService.findById(id);
        return ResponseEntity.ok((Object)savedActivity);
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#activityDTO.researcherId)) : true")
    public ResponseEntity<ActivityDTO> updateActivity(@RequestBody ActivityDTO dto) {
        if (dto.getId() == null) {
            throw new IllegalArgumentException("Activity has null id! You cannot update a profile without a valid id");
        }
        return ResponseEntity.ok((Object)this.activityService.updateActivity(dto));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteActivity(@PathVariable Long id) {
        this.activityService.deleteActivity(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/earliest-year"})
    public ResponseEntity<Integer> getEarliestFromYear(@RequestParam Long researcherId) {
        return ResponseEntity.ok((Object)this.activityService.getEarliestFromYear(researcherId));
    }

    @GetMapping(value={"/years"})
    public ResponseEntity<List<Integer>> getAllYears(@RequestParam Long researcherId) {
        return ResponseEntity.ok((Object)this.activityService.getAllYears(researcherId));
    }

    @GetMapping(value={"/auth-test"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#researcherId)) : true")
    public ResponseEntity<String> getResponse(@RequestParam Long researcherId) {
        return ResponseEntity.ok((Object)"You are authorized!");
    }

    @PostMapping(value={"/auth-test-profile"})
    @PreAuthorize(value="@ProfileCheck.isSecurityEnabled() ? (hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN) || @ORCID.checkOrcidByResearcherId(#activityDTO.researcherId)) : true")
    public ResponseEntity<String> getResponse(@RequestBody ActivityDTO activityDTO) {
        return ResponseEntity.ok((Object)"You are authorized!");
    }
}

