/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.services;

import eu.dnet.researcher.dto.FeaturedArticleDTO;
import eu.dnet.researcher.mapper.FeaturedArticleMapper;
import eu.dnet.researcher.postgresql.FeaturedArticle;
import eu.dnet.researcher.repositories.FeaturedArticleRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeaturedArticleService {
    @Autowired
    FeaturedArticleRepository featuredArticleRepository;
    @Autowired
    FeaturedArticleMapper featuredArticleMapper;

    public FeaturedArticleDTO createArticle(FeaturedArticleDTO dto) {
        FeaturedArticle entity = this.featuredArticleMapper.toFeaturedArticle(dto);
        entity = (FeaturedArticle)this.featuredArticleRepository.save((Object)entity);
        return this.featuredArticleMapper.toFeaturedArticleDTO(entity);
    }

    public FeaturedArticleDTO getArticleById(Long id) {
        return this.featuredArticleRepository.findById((Object)id).map(arg_0 -> ((FeaturedArticleMapper)this.featuredArticleMapper).toFeaturedArticleDTO(arg_0)).orElseThrow(() -> new RuntimeException("Article not found"));
    }

    public List<FeaturedArticleDTO> getAllArticles() {
        return this.featuredArticleRepository.findAll().stream().map(arg_0 -> ((FeaturedArticleMapper)this.featuredArticleMapper).toFeaturedArticleDTO(arg_0)).toList();
    }

    public List<FeaturedArticleDTO> getAllArticlesByResearcherId(Long researcherId) {
        return this.featuredArticleRepository.findByResearcherId(researcherId).stream().map(arg_0 -> ((FeaturedArticleMapper)this.featuredArticleMapper).toFeaturedArticleDTO(arg_0)).toList();
    }

    public void deleteArticle(Long id) {
        this.featuredArticleRepository.deleteById((Object)id);
    }

    public FeaturedArticleDTO updateArticle(FeaturedArticleDTO dto) {
        this.featuredArticleRepository.findById((Object)dto.getId()).orElseThrow(() -> new RuntimeException("Article " + dto.getId() + " not found"));
        FeaturedArticle entity = this.featuredArticleMapper.toFeaturedArticle(dto);
        return this.featuredArticleMapper.toFeaturedArticleDTO((FeaturedArticle)this.featuredArticleRepository.save((Object)entity));
    }
}

