/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.services;

import eu.dnet.researcher.postgresql.ImpactCategory;
import eu.dnet.researcher.postgresql.ImpactWork;
import eu.dnet.researcher.repositories.ImpactCategoryRepository;
import eu.dnet.researcher.repositories.ImpactWorkRepository;
import eu.dnet.researcher.utils.ImpactHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImpactCategoryService {
    @Autowired
    private ImpactCategoryRepository impactCategoryRepository;
    @Autowired
    private ImpactWorkRepository impactWorkRepository;

    public ImpactCategory save(ImpactCategory impactCategory) {
        return (ImpactCategory)this.impactCategoryRepository.save((Object)impactCategory);
    }

    public void deleteByIdWithSubCategoriesAndWorks(Long id) {
        ImpactCategory category = this.findById(id);
        if (category.getSubCategory() == null) {
            List subCategories = this.impactCategoryRepository.findByResearcherIdAndActivityConfigurationAndCategory(category.getResearcherId(), category.getActivityConfiguration(), category.getCategory());
            for (ImpactCategory subCategory : subCategories) {
                this.deleteSubCategoryAndWorks(subCategory);
            }
            this.impactCategoryRepository.deleteById((Object)id);
        } else {
            this.deleteSubCategoryAndWorks(category);
        }
    }

    public void deleteSubCategoryAndWorks(ImpactCategory category) {
        List works = this.impactWorkRepository.findByResearcherIdAndActivityConfigurationAndCategoryAndSubCategory(category.getResearcherId(), category.getActivityConfiguration(), category.getCategory(), category.getSubCategory());
        for (ImpactWork work : works) {
            this.impactWorkRepository.deleteById((Object)work.getId());
        }
        this.impactCategoryRepository.deleteById((Object)category.getId());
    }

    public ImpactCategory findById(Long id) {
        return this.impactCategoryRepository.findById((Object)id).orElse(null);
    }

    public String initializeCategories(Long researcherId) {
        System.out.println("SKATA");
        if (this.impactCategoryRepository.findByResearcherId(researcherId).isEmpty()) {
            System.out.println("EMPTYYYY");
            List list = ImpactHelper.initializeImpactCategories((Long)researcherId);
            list.forEach(category -> this.impactCategoryRepository.save(category));
            return "ok!";
        }
        return "Already initialized";
    }
}

