/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.services;

import eu.dnet.researcher.dto.ActivityDTO;
import eu.dnet.researcher.mapper.ActivityMapper;
import eu.dnet.researcher.postgresql.Activity;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.repositories.ActivityRepository;
import eu.dnet.researcher.repositories.ResearcherProfileRepository;
import jakarta.persistence.EntityNotFoundException;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityService {
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ResearcherProfileRepository researcherProfileRepository;

    public ActivityDTO save(ActivityDTO activityDTO) {
        return this.saveActivity(activityDTO);
    }

    public ActivityDTO findById(Long id) {
        return this.activityRepository.findById((Object)id).map(arg_0 -> ((ActivityMapper)this.activityMapper).toActivityDTO(arg_0)).orElseThrow(() -> new RuntimeException("Activity not found"));
    }

    public void deleteActivity(Long id) {
        this.activityRepository.deleteById((Object)id);
    }

    public ActivityDTO updateActivity(ActivityDTO dto) {
        return this.saveActivity(dto);
    }

    public List<ActivityDTO> findByResearcherId(Long researcherId, LocalDate from, LocalDate to) {
        List activities = from != null && to != null ? this.activityRepository.findByResearcherIdAndYearRange(researcherId, from, to) : this.activityRepository.findByResearcherId(researcherId);
        return activities.stream().map(arg_0 -> ((ActivityMapper)this.activityMapper).toActivityDTO(arg_0)).collect(Collectors.toList());
    }

    public List<ActivityDTO> findByActivityIdAndResearcherId(Long activityId, Long researcherId, LocalDate from, LocalDate to) {
        List activities = from != null && to != null ? this.activityRepository.findByActivityIdAndResearcherIdAndYearRange(activityId, researcherId, from, to) : this.activityRepository.findByActivityConfigurationAndResearcherId(activityId, researcherId);
        return activities.stream().map(arg_0 -> ((ActivityMapper)this.activityMapper).toActivityDTO(arg_0)).collect(Collectors.toList());
    }

    public List<ActivityDTO> findByResearcherIdAndYearRange(Long researcherId, LocalDate from, LocalDate to) {
        List activities = this.activityRepository.findByResearcherId(researcherId);
        return activities.stream().map(arg_0 -> ((ActivityMapper)this.activityMapper).toActivityDTO(arg_0)).collect(Collectors.toList());
    }

    public ActivityDTO saveActivity(ActivityDTO activityDTO) {
        Long researcherId = activityDTO.getResearcherId();
        if (activityDTO.getId() != null) {
            Optional entity = this.activityRepository.findById((Object)activityDTO.getId());
            if (entity.isEmpty()) {
                throw new EntityNotFoundException("You cannot update the activity with id " + activityDTO.getId() + ". It does not exist in DB");
            }
            if (!((Activity)entity.get()).getResearcher().getId().equals(activityDTO.getResearcherId())) {
                throw new IllegalArgumentException("You cannot update the activity with id " + activityDTO.getId() + ". It does not match the researcher id " + activityDTO.getResearcherId() + ".");
            }
        }
        ResearcherProfile researcherProfile = (ResearcherProfile)this.researcherProfileRepository.findById((Object)researcherId).orElseThrow(() -> new EntityNotFoundException("Researcher with id " + researcherId + " not found"));
        Activity activity = this.activityMapper.toActivity(activityDTO);
        activity.setResearcher(researcherProfile);
        this.activityRepository.save((Object)activity);
        return this.activityMapper.toActivityDTO(activity);
    }

    public Integer getEarliestFromYear(Long researcherId) {
        LocalDate earliestDate = this.activityRepository.findEarliestFromDateByResearcher(researcherId);
        return earliestDate != null ? Integer.valueOf(earliestDate.getYear()) : null;
    }

    public List<Integer> getAllYears(Long researcherId) {
        return this.activityRepository.findAllYears(researcherId);
    }
}

