/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.controller;

import eu.dnet.researcher.dto.TimePeriodDTO;
import eu.dnet.researcher.services.TimePeriodService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/timePeriods"})
public class TimePeriodController {
    @Autowired
    TimePeriodService timePeriodService;

    @PostMapping(value={"/create"})
    public ResponseEntity<TimePeriodDTO> createTimePeriod(@RequestBody TimePeriodDTO timePeriodDTO) {
        this.checkDates(timePeriodDTO.getFromDate(), timePeriodDTO.getToDate());
        TimePeriodDTO savedTimePeriod = this.timePeriodService.save(timePeriodDTO);
        return ResponseEntity.ok((Object)savedTimePeriod);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<TimePeriodDTO> getArticle(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.timePeriodService.getTimePeriodById(id));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity updateTimePeriod(@RequestBody TimePeriodDTO timePeriodDTO) {
        this.checkDates(timePeriodDTO.getFromDate(), timePeriodDTO.getToDate());
        if (timePeriodDTO.getId() == null) {
            throw new IllegalArgumentException("Time period has null id! You cannot update time period without a valid id");
        }
        return ResponseEntity.ok((Object)this.timePeriodService.update(timePeriodDTO));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity deleteTimePeriod(@PathVariable Long id) {
        this.timePeriodService.delete(id);
        return ResponseEntity.noContent().build();
    }

    private void checkDates(String from, String to) {
        if (!(from == null || to == null || from.matches("\\d{4}") && to.matches("\\d{4}"))) {
            throw new IllegalArgumentException("Invalid year format. Expected format: yyyy");
        }
        if (from == null && to == null) {
            throw new IllegalArgumentException("Invalid year format. Years cannot be null or empty. Accepted format: yyyy");
        }
        if (Integer.parseInt(from) >= Integer.parseInt(to)) {
            throw new IllegalArgumentException("Invalid year input: from cannot be greater than to");
        }
    }
}

