/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.mapper;

import eu.dnet.researcher.dto.TimePeriodDTO;
import eu.dnet.researcher.mapper.TimePeriodMapper;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.postgresql.TimePeriod;
import eu.dnet.researcher.utils.LocalDateHelper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimePeriodMapperImpl
implements TimePeriodMapper {
    @Autowired
    private LocalDateHelper localDateHelper;

    public TimePeriod toTimePeriod(TimePeriodDTO dto) {
        List list3;
        List list2;
        List list1;
        if (dto == null) {
            return null;
        }
        TimePeriod.TimePeriodBuilder timePeriod = TimePeriod.builder();
        timePeriod.fromDate(this.localDateHelper.convertFromYearToLocalDate(dto.getFromDate()));
        timePeriod.toDate(this.localDateHelper.convertToYearToLocalDate(dto.getToDate()));
        timePeriod.id(dto.getId());
        timePeriod.title(dto.getTitle());
        timePeriod.description(dto.getDescription());
        List list = dto.getActivities();
        if (list != null) {
            timePeriod.activities(new ArrayList(list));
        }
        if ((list1 = dto.getResults()) != null) {
            timePeriod.results(new ArrayList(list1));
        }
        if ((list2 = dto.getProjects()) != null) {
            timePeriod.projects(new ArrayList(list2));
        }
        if ((list3 = dto.getFundings()) != null) {
            timePeriod.fundings(new ArrayList(list3));
        }
        return timePeriod.build();
    }

    public TimePeriodDTO toTimePeriodDto(TimePeriod timePeriod) {
        List list3;
        List list2;
        List list1;
        if (timePeriod == null) {
            return null;
        }
        TimePeriodDTO timePeriodDTO = new TimePeriodDTO();
        timePeriodDTO.setResearcherId(this.timePeriodResearcherId(timePeriod));
        timePeriodDTO.setFromDate(this.localDateHelper.extractYearFromLocalDate(timePeriod.getFromDate()));
        timePeriodDTO.setToDate(this.localDateHelper.extractYearFromLocalDate(timePeriod.getToDate()));
        timePeriodDTO.setId(timePeriod.getId());
        timePeriodDTO.setTitle(timePeriod.getTitle());
        timePeriodDTO.setDescription(timePeriod.getDescription());
        List list = timePeriod.getActivities();
        if (list != null) {
            timePeriodDTO.setActivities(new ArrayList(list));
        }
        if ((list1 = timePeriod.getResults()) != null) {
            timePeriodDTO.setResults(new ArrayList(list1));
        }
        if ((list2 = timePeriod.getProjects()) != null) {
            timePeriodDTO.setProjects(new ArrayList(list2));
        }
        if ((list3 = timePeriod.getFundings()) != null) {
            timePeriodDTO.setFundings(new ArrayList(list3));
        }
        return timePeriodDTO;
    }

    private Long timePeriodResearcherId(TimePeriod timePeriod) {
        if (timePeriod == null) {
            return null;
        }
        ResearcherProfile researcher = timePeriod.getResearcher();
        if (researcher == null) {
            return null;
        }
        Long id = researcher.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

