/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.services;

import eu.dnet.researcher.dto.FundingDTO;
import eu.dnet.researcher.mapper.FundingMapper;
import eu.dnet.researcher.postgresql.Funding;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.repositories.FundingRepository;
import eu.dnet.researcher.repositories.ResearcherProfileRepository;
import jakarta.persistence.EntityNotFoundException;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FundingService {
    @Autowired
    ResearcherProfileRepository researcherProfileRepository;
    @Autowired
    FundingRepository fundingRepository;
    @Autowired
    FundingMapper fundingMapper;

    public FundingDTO save(FundingDTO fundingDTO) {
        return this.saveFunding(fundingDTO);
    }

    public FundingDTO findById(Long id) {
        return this.fundingRepository.findById((Object)id).map(arg_0 -> ((FundingMapper)this.fundingMapper).toFundingDTO(arg_0)).orElseThrow(() -> new RuntimeException("Funding " + id + " not found"));
    }

    public void deleteFunding(Long id) {
        this.fundingRepository.deleteById((Object)id);
    }

    public FundingDTO updateFunding(FundingDTO request) {
        this.fundingRepository.findById((Object)request.getId()).orElseThrow(() -> new RuntimeException("Funding " + request.getId() + " not found"));
        return this.saveFunding(request);
    }

    public FundingDTO saveFunding(FundingDTO fundingDTO) {
        Long researcherId = fundingDTO.getResearcherId();
        if (fundingDTO.getId() != null) {
            Optional entity = this.fundingRepository.findById((Object)fundingDTO.getId());
            if (entity.isEmpty()) {
                throw new EntityNotFoundException("You cannot update the funding with id " + fundingDTO.getId() + ". It does not exist in DB");
            }
            if (!((Funding)entity.get()).getResearcher().getId().equals(fundingDTO.getResearcherId())) {
                throw new IllegalArgumentException("You cannot update the funding with id " + fundingDTO.getId() + ". It does not match the researcher id " + fundingDTO.getResearcherId() + ".");
            }
        }
        ResearcherProfile researcherProfile = (ResearcherProfile)this.researcherProfileRepository.findById((Object)researcherId).orElseThrow(() -> new EntityNotFoundException("Researcher with id " + researcherId + " not found"));
        Funding funding = this.fundingMapper.toFunding(fundingDTO);
        funding.setResearcher(researcherProfile);
        return this.fundingMapper.toFundingDTO((Funding)this.fundingRepository.save((Object)funding));
    }

    public List<FundingDTO> findByResearcherId(Long researcherId, LocalDate from, LocalDate to) {
        List fundings = from != null && to != null ? this.fundingRepository.findByResearcherIdAndYearRange(researcherId, from, to) : this.fundingRepository.findByResearcherId(researcherId);
        return fundings.stream().map(arg_0 -> ((FundingMapper)this.fundingMapper).toFundingDTO(arg_0)).collect(Collectors.toList());
    }
}

