/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.mapper;

import eu.dnet.researcher.dto.ActivityDTO;
import eu.dnet.researcher.mapper.ActivityMapper;
import eu.dnet.researcher.postgresql.Activity;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.utils.LocalDateHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityMapperImpl
implements ActivityMapper {
    @Autowired
    private LocalDateHelper localDateHelper;

    public Activity toActivity(ActivityDTO activityDTO) {
        if (activityDTO == null) {
            return null;
        }
        Activity.ActivityBuilder activity = Activity.builder();
        if (activityDTO.getFromDate() != null) {
            activity.fromDate(this.localDateHelper.convertTimestamp(String.valueOf(activityDTO.getFromDate())));
        }
        if (activityDTO.getToDate() != null) {
            activity.toDate(this.localDateHelper.convertTimestamp(String.valueOf(activityDTO.getToDate())));
        }
        activity.id(activityDTO.getId());
        activity.activityConfiguration(activityDTO.getActivityConfiguration());
        activity.type(activityDTO.getType());
        activity.department(activityDTO.getDepartment());
        activity.role(activityDTO.getRole());
        activity.title(activityDTO.getTitle());
        activity.url(activityDTO.getUrl());
        activity.source(activityDTO.getSource());
        activity.synced(activityDTO.getSynced());
        activity.createdAt(activityDTO.getCreatedAt());
        activity.updatedAt(activityDTO.getUpdatedAt());
        activity.visibility(activityDTO.getVisibility());
        activity.organizationName(activityDTO.getOrganizationName());
        activity.organizationCity(activityDTO.getOrganizationCity());
        activity.organizationCountry(activityDTO.getOrganizationCountry());
        activity.organizationUrl(activityDTO.getOrganizationUrl());
        activity.organizationDisId(activityDTO.getOrganizationDisId());
        activity.organizationDisSource(activityDTO.getOrganizationDisSource());
        activity.orcidPutCode(activityDTO.getOrcidPutCode());
        return activity.build();
    }

    public ActivityDTO toActivityDTO(Activity activity) {
        if (activity == null) {
            return null;
        }
        ActivityDTO.ActivityDTOBuilder activityDTO = ActivityDTO.builder();
        activityDTO.researcherId(this.activityResearcherId(activity));
        activityDTO.fromDate(this.localDateHelper.convertLocalDate(activity.getFromDate()));
        activityDTO.toDate(this.localDateHelper.convertLocalDate(activity.getToDate()));
        activityDTO.id(activity.getId());
        activityDTO.activityConfiguration(activity.getActivityConfiguration());
        activityDTO.type(activity.getType());
        activityDTO.department(activity.getDepartment());
        activityDTO.role(activity.getRole());
        activityDTO.title(activity.getTitle());
        activityDTO.url(activity.getUrl());
        activityDTO.source(activity.getSource());
        activityDTO.createdAt(activity.getCreatedAt());
        activityDTO.updatedAt(activity.getUpdatedAt());
        activityDTO.visibility(activity.getVisibility());
        activityDTO.synced(activity.getSynced());
        activityDTO.organizationName(activity.getOrganizationName());
        activityDTO.organizationCity(activity.getOrganizationCity());
        activityDTO.organizationCountry(activity.getOrganizationCountry());
        activityDTO.organizationUrl(activity.getOrganizationUrl());
        activityDTO.organizationDisId(activity.getOrganizationDisId());
        activityDTO.organizationDisSource(activity.getOrganizationDisSource());
        activityDTO.orcidPutCode(activity.getOrcidPutCode());
        return activityDTO.build();
    }

    private Long activityResearcherId(Activity activity) {
        if (activity == null) {
            return null;
        }
        ResearcherProfile researcher = activity.getResearcher();
        if (researcher == null) {
            return null;
        }
        Long id = researcher.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

