/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.mapper;

import eu.dnet.researcher.dto.ActivityDTO;
import eu.dnet.researcher.dto.FundingDTO;
import eu.dnet.researcher.dto.ResearcherEmailDTO;
import eu.dnet.researcher.dto.ResearcherPidDTO;
import eu.dnet.researcher.dto.ResearcherProfileDTO;
import eu.dnet.researcher.dto.TimePeriodDTO;
import eu.dnet.researcher.mapper.ActivityMapper;
import eu.dnet.researcher.mapper.FundingMapper;
import eu.dnet.researcher.mapper.ResearcherProfileMapper;
import eu.dnet.researcher.mapper.TimePeriodMapper;
import eu.dnet.researcher.postgresql.Activity;
import eu.dnet.researcher.postgresql.Funding;
import eu.dnet.researcher.postgresql.ResearcherEmail;
import eu.dnet.researcher.postgresql.ResearcherPid;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import eu.dnet.researcher.postgresql.TimePeriod;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResearcherProfileMapperImpl
implements ResearcherProfileMapper {
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private FundingMapper fundingMapper;
    @Autowired
    private TimePeriodMapper timePeriodMapper;

    public void updateBasicResearcherProfileFromDto(ResearcherProfileDTO dto, ResearcherProfile entity) {
        if (dto == null) {
            return;
        }
        entity.setId(dto.getId());
        entity.setBio(dto.getBio());
        entity.setOpenaireId(dto.getOpenaireId());
        entity.setSource(dto.getSource());
        entity.setProfileVisibility(dto.getProfileVisibility());
        entity.setOrcid(dto.getOrcid());
        entity.setFullname(dto.getFullname());
        entity.setFirstname(dto.getFirstname());
        entity.setLastname(dto.getLastname());
        entity.setFullnameSource(dto.getFullnameSource());
        entity.setBioSource(dto.getBioSource());
        entity.setTitle(dto.getTitle());
        if (entity.getEmails() != null) {
            list = this.researcherEmailDTOListToResearcherEmailList(dto.getEmails());
            if (list != null) {
                entity.getEmails().clear();
                entity.getEmails().addAll(list);
            } else {
                entity.setEmails(null);
            }
        } else {
            list = this.researcherEmailDTOListToResearcherEmailList(dto.getEmails());
            if (list != null) {
                entity.setEmails(list);
            }
        }
        if (entity.getPids() != null) {
            list1 = this.researcherPidDTOListToResearcherPidList(dto.getPids());
            if (list1 != null) {
                entity.getPids().clear();
                entity.getPids().addAll(list1);
            } else {
                entity.setPids(null);
            }
        } else {
            list1 = this.researcherPidDTOListToResearcherPidList(dto.getPids());
            if (list1 != null) {
                entity.setPids(list1);
            }
        }
    }

    public ResearcherProfile toResearcherProfile(ResearcherProfileDTO researcherProfileDTO) {
        if (researcherProfileDTO == null) {
            return null;
        }
        ResearcherProfile.ResearcherProfileBuilder researcherProfile = ResearcherProfile.builder();
        researcherProfile.id(researcherProfileDTO.getId());
        researcherProfile.bio(researcherProfileDTO.getBio());
        researcherProfile.openaireId(researcherProfileDTO.getOpenaireId());
        researcherProfile.source(researcherProfileDTO.getSource());
        researcherProfile.profileVisibility(researcherProfileDTO.getProfileVisibility());
        researcherProfile.orcid(researcherProfileDTO.getOrcid());
        researcherProfile.fullname(researcherProfileDTO.getFullname());
        researcherProfile.firstname(researcherProfileDTO.getFirstname());
        researcherProfile.lastname(researcherProfileDTO.getLastname());
        researcherProfile.fullnameSource(researcherProfileDTO.getFullnameSource());
        researcherProfile.bioSource(researcherProfileDTO.getBioSource());
        researcherProfile.title(researcherProfileDTO.getTitle());
        researcherProfile.emails(this.researcherEmailDTOListToResearcherEmailList(researcherProfileDTO.getEmails()));
        researcherProfile.pids(this.researcherPidDTOListToResearcherPidList(researcherProfileDTO.getPids()));
        researcherProfile.activities(this.activityDTOListToActivityList(researcherProfileDTO.getActivities()));
        researcherProfile.fundings(this.fundingDTOListToFundingList(researcherProfileDTO.getFundings()));
        researcherProfile.timeline(this.timePeriodDTOListToTimePeriodList(researcherProfileDTO.getTimeline()));
        return researcherProfile.build();
    }

    public ResearcherProfile toBasicResearcherProfile(ResearcherProfileDTO researcherProfileDTO) {
        if (researcherProfileDTO == null) {
            return null;
        }
        ResearcherProfile.ResearcherProfileBuilder researcherProfile = ResearcherProfile.builder();
        researcherProfile.id(researcherProfileDTO.getId());
        researcherProfile.bio(researcherProfileDTO.getBio());
        researcherProfile.openaireId(researcherProfileDTO.getOpenaireId());
        researcherProfile.source(researcherProfileDTO.getSource());
        researcherProfile.profileVisibility(researcherProfileDTO.getProfileVisibility());
        researcherProfile.orcid(researcherProfileDTO.getOrcid());
        researcherProfile.fullname(researcherProfileDTO.getFullname());
        researcherProfile.firstname(researcherProfileDTO.getFirstname());
        researcherProfile.lastname(researcherProfileDTO.getLastname());
        researcherProfile.fullnameSource(researcherProfileDTO.getFullnameSource());
        researcherProfile.bioSource(researcherProfileDTO.getBioSource());
        researcherProfile.title(researcherProfileDTO.getTitle());
        return researcherProfile.build();
    }

    public ResearcherProfile toRearcherProfile(ResearcherProfileDTO researcherProfileDTO) {
        if (researcherProfileDTO == null) {
            return null;
        }
        ResearcherProfile.ResearcherProfileBuilder researcherProfile = ResearcherProfile.builder();
        researcherProfile.id(researcherProfileDTO.getId());
        researcherProfile.bio(researcherProfileDTO.getBio());
        researcherProfile.openaireId(researcherProfileDTO.getOpenaireId());
        researcherProfile.source(researcherProfileDTO.getSource());
        researcherProfile.profileVisibility(researcherProfileDTO.getProfileVisibility());
        researcherProfile.orcid(researcherProfileDTO.getOrcid());
        researcherProfile.fullname(researcherProfileDTO.getFullname());
        researcherProfile.firstname(researcherProfileDTO.getFirstname());
        researcherProfile.lastname(researcherProfileDTO.getLastname());
        researcherProfile.fullnameSource(researcherProfileDTO.getFullnameSource());
        researcherProfile.bioSource(researcherProfileDTO.getBioSource());
        researcherProfile.title(researcherProfileDTO.getTitle());
        researcherProfile.emails(this.researcherEmailDTOListToResearcherEmailList(researcherProfileDTO.getEmails()));
        researcherProfile.pids(this.researcherPidDTOListToResearcherPidList(researcherProfileDTO.getPids()));
        researcherProfile.activities(this.activityDTOListToActivityList(researcherProfileDTO.getActivities()));
        researcherProfile.fundings(this.fundingDTOListToFundingList(researcherProfileDTO.getFundings()));
        researcherProfile.timeline(this.timePeriodDTOListToTimePeriodList(researcherProfileDTO.getTimeline()));
        return researcherProfile.build();
    }

    public ResearcherProfileDTO toResearcherProfileDTO(ResearcherProfile researcherProfile) {
        if (researcherProfile == null) {
            return null;
        }
        ResearcherProfileDTO researcherProfileDTO = new ResearcherProfileDTO();
        researcherProfileDTO.setId(researcherProfile.getId());
        researcherProfileDTO.setFullname(researcherProfile.getFullname());
        researcherProfileDTO.setFirstname(researcherProfile.getFirstname());
        researcherProfileDTO.setLastname(researcherProfile.getLastname());
        researcherProfileDTO.setTitle(researcherProfile.getTitle());
        researcherProfileDTO.setOpenaireId(researcherProfile.getOpenaireId());
        researcherProfileDTO.setBio(researcherProfile.getBio());
        researcherProfileDTO.setSource(researcherProfile.getSource());
        researcherProfileDTO.setProfileVisibility(researcherProfile.getProfileVisibility());
        researcherProfileDTO.setOrcid(researcherProfile.getOrcid());
        researcherProfileDTO.setFullnameSource(researcherProfile.getFullnameSource());
        researcherProfileDTO.setBioSource(researcherProfile.getBioSource());
        researcherProfileDTO.setEmails(this.researcherEmailListToResearcherEmailDTOList(researcherProfile.getEmails()));
        researcherProfileDTO.setPids(this.researcherPidListToResearcherPidDTOList(researcherProfile.getPids()));
        researcherProfileDTO.setActivities(this.activityListToActivityDTOList(researcherProfile.getActivities()));
        researcherProfileDTO.setFundings(this.fundingListToFundingDTOList(researcherProfile.getFundings()));
        researcherProfileDTO.setTimeline(this.timePeriodListToTimePeriodDTOList(researcherProfile.getTimeline()));
        return researcherProfileDTO;
    }

    protected ResearcherEmail researcherEmailDTOToResearcherEmail(ResearcherEmailDTO researcherEmailDTO) {
        if (researcherEmailDTO == null) {
            return null;
        }
        ResearcherEmail.ResearcherEmailBuilder researcherEmail = ResearcherEmail.builder();
        researcherEmail.id(researcherEmailDTO.getId());
        researcherEmail.email(researcherEmailDTO.getEmail());
        researcherEmail.isPrimary(researcherEmailDTO.getIsPrimary());
        researcherEmail.isVisible(researcherEmailDTO.getIsVisible());
        return researcherEmail.build();
    }

    protected List<ResearcherEmail> researcherEmailDTOListToResearcherEmailList(List<ResearcherEmailDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ResearcherEmail> list1 = new ArrayList<ResearcherEmail>(list.size());
        for (ResearcherEmailDTO researcherEmailDTO : list) {
            list1.add(this.researcherEmailDTOToResearcherEmail(researcherEmailDTO));
        }
        return list1;
    }

    protected ResearcherPid researcherPidDTOToResearcherPid(ResearcherPidDTO researcherPidDTO) {
        if (researcherPidDTO == null) {
            return null;
        }
        ResearcherPid.ResearcherPidBuilder researcherPid = ResearcherPid.builder();
        researcherPid.id(researcherPidDTO.getId());
        researcherPid.type(researcherPidDTO.getType());
        researcherPid.value(researcherPidDTO.getValue());
        researcherPid.url(researcherPidDTO.getUrl());
        researcherPid.source(researcherPidDTO.getSource());
        researcherPid.orcidPutCode(researcherPidDTO.getOrcidPutCode());
        researcherPid.isVisible(researcherPidDTO.getIsVisible());
        return researcherPid.build();
    }

    protected List<ResearcherPid> researcherPidDTOListToResearcherPidList(List<ResearcherPidDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ResearcherPid> list1 = new ArrayList<ResearcherPid>(list.size());
        for (ResearcherPidDTO researcherPidDTO : list) {
            list1.add(this.researcherPidDTOToResearcherPid(researcherPidDTO));
        }
        return list1;
    }

    protected List<Activity> activityDTOListToActivityList(List<ActivityDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Activity> list1 = new ArrayList<Activity>(list.size());
        for (ActivityDTO activityDTO : list) {
            list1.add(this.activityMapper.toActivity(activityDTO));
        }
        return list1;
    }

    protected List<Funding> fundingDTOListToFundingList(List<FundingDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Funding> list1 = new ArrayList<Funding>(list.size());
        for (FundingDTO fundingDTO : list) {
            list1.add(this.fundingMapper.toFunding(fundingDTO));
        }
        return list1;
    }

    protected List<TimePeriod> timePeriodDTOListToTimePeriodList(List<TimePeriodDTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TimePeriod> list1 = new ArrayList<TimePeriod>(list.size());
        for (TimePeriodDTO timePeriodDTO : list) {
            list1.add(this.timePeriodMapper.toTimePeriod(timePeriodDTO));
        }
        return list1;
    }

    protected ResearcherEmailDTO researcherEmailToResearcherEmailDTO(ResearcherEmail researcherEmail) {
        if (researcherEmail == null) {
            return null;
        }
        ResearcherEmailDTO researcherEmailDTO = new ResearcherEmailDTO();
        researcherEmailDTO.setId(researcherEmail.getId());
        researcherEmailDTO.setEmail(researcherEmail.getEmail());
        researcherEmailDTO.setIsPrimary(researcherEmail.getIsPrimary());
        researcherEmailDTO.setIsVisible(researcherEmail.getIsVisible());
        return researcherEmailDTO;
    }

    protected List<ResearcherEmailDTO> researcherEmailListToResearcherEmailDTOList(List<ResearcherEmail> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ResearcherEmailDTO> list1 = new ArrayList<ResearcherEmailDTO>(list.size());
        for (ResearcherEmail researcherEmail : list) {
            list1.add(this.researcherEmailToResearcherEmailDTO(researcherEmail));
        }
        return list1;
    }

    protected ResearcherPidDTO researcherPidToResearcherPidDTO(ResearcherPid researcherPid) {
        if (researcherPid == null) {
            return null;
        }
        ResearcherPidDTO researcherPidDTO = new ResearcherPidDTO();
        researcherPidDTO.setId(researcherPid.getId());
        researcherPidDTO.setType(researcherPid.getType());
        researcherPidDTO.setValue(researcherPid.getValue());
        researcherPidDTO.setUrl(researcherPid.getUrl());
        researcherPidDTO.setSource(researcherPid.getSource());
        researcherPidDTO.setOrcidPutCode(researcherPid.getOrcidPutCode());
        researcherPidDTO.setIsVisible(researcherPid.getIsVisible());
        return researcherPidDTO;
    }

    protected List<ResearcherPidDTO> researcherPidListToResearcherPidDTOList(List<ResearcherPid> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ResearcherPidDTO> list1 = new ArrayList<ResearcherPidDTO>(list.size());
        for (ResearcherPid researcherPid : list) {
            list1.add(this.researcherPidToResearcherPidDTO(researcherPid));
        }
        return list1;
    }

    protected List<ActivityDTO> activityListToActivityDTOList(List<Activity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ActivityDTO> list1 = new ArrayList<ActivityDTO>(list.size());
        for (Activity activity : list) {
            list1.add(this.activityMapper.toActivityDTO(activity));
        }
        return list1;
    }

    protected List<FundingDTO> fundingListToFundingDTOList(List<Funding> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FundingDTO> list1 = new ArrayList<FundingDTO>(list.size());
        for (Funding funding : list) {
            list1.add(this.fundingMapper.toFundingDTO(funding));
        }
        return list1;
    }

    protected List<TimePeriodDTO> timePeriodListToTimePeriodDTOList(List<TimePeriod> list) {
        if (list == null) {
            return null;
        }
        ArrayList<TimePeriodDTO> list1 = new ArrayList<TimePeriodDTO>(list.size());
        for (TimePeriod timePeriod : list) {
            list1.add(this.timePeriodMapper.toTimePeriodDto(timePeriod));
        }
        return list1;
    }
}

