/*
 * Decompiled with CFR 0.152.
 */
package eu.dnet.researcher.postgresql;

import com.fasterxml.jackson.annotation.JsonFormat;
import eu.dnet.researcher.postgresql.Funding;
import eu.dnet.researcher.postgresql.ResearcherProfile;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.Instant;
import java.time.LocalDate;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="funding")
public class Funding {
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Id
    private Long id;
    @ManyToOne
    @JoinColumn(name="researcher_id", nullable=false)
    private ResearcherProfile researcher;
    @NotNull
    @Column(name="activity_configuration")
    private Long activityConfiguration;
    @Column(name="from_date")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate fromDate;
    @Column(name="to_date")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate toDate;
    @Column(name="title")
    private String title;
    @Column(name="funding_type")
    private String fundingType;
    @Column(name="funding_id_type")
    private String fundingIdType;
    @Column(name="funding_id_value")
    private String fundingIdValue;
    @Column(name="funding_relationship")
    private String fundingRelationship;
    @Column(name="source")
    private String source;
    @Column(name="synced", columnDefinition="boolean default false")
    private Boolean synced;
    @Column(name="organization_name")
    private String organizationName;
    @Column(name="organization_city")
    private String organizationCity;
    @Column(name="organization_country")
    private String organizationCountry;
    @Column(name="organization_url")
    private String organizationUrl;
    @Column(name="organization_dis_id")
    private String organizationDisId;
    @Column(name="organization_dis_source")
    private String organizationDisSource;
    @CreationTimestamp
    @Column(name="created_at", updatable=false)
    private Instant createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private Instant updatedAt;
    @Column(name="visibility")
    private Boolean visibility;
    @Column(name="orcid_put_code")
    private String orcidPutCode;

    public static FundingBuilder builder() {
        return new FundingBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public ResearcherProfile getResearcher() {
        return this.researcher;
    }

    public Long getActivityConfiguration() {
        return this.activityConfiguration;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFundingType() {
        return this.fundingType;
    }

    public String getFundingIdType() {
        return this.fundingIdType;
    }

    public String getFundingIdValue() {
        return this.fundingIdValue;
    }

    public String getFundingRelationship() {
        return this.fundingRelationship;
    }

    public String getSource() {
        return this.source;
    }

    public Boolean getSynced() {
        return this.synced;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getOrganizationCity() {
        return this.organizationCity;
    }

    public String getOrganizationCountry() {
        return this.organizationCountry;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public String getOrganizationDisId() {
        return this.organizationDisId;
    }

    public String getOrganizationDisSource() {
        return this.organizationDisSource;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public Boolean getVisibility() {
        return this.visibility;
    }

    public String getOrcidPutCode() {
        return this.orcidPutCode;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setResearcher(ResearcherProfile researcher) {
        this.researcher = researcher;
    }

    public void setActivityConfiguration(Long activityConfiguration) {
        this.activityConfiguration = activityConfiguration;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFundingType(String fundingType) {
        this.fundingType = fundingType;
    }

    public void setFundingIdType(String fundingIdType) {
        this.fundingIdType = fundingIdType;
    }

    public void setFundingIdValue(String fundingIdValue) {
        this.fundingIdValue = fundingIdValue;
    }

    public void setFundingRelationship(String fundingRelationship) {
        this.fundingRelationship = fundingRelationship;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSynced(Boolean synced) {
        this.synced = synced;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public void setOrganizationCity(String organizationCity) {
        this.organizationCity = organizationCity;
    }

    public void setOrganizationCountry(String organizationCountry) {
        this.organizationCountry = organizationCountry;
    }

    public void setOrganizationUrl(String organizationUrl) {
        this.organizationUrl = organizationUrl;
    }

    public void setOrganizationDisId(String organizationDisId) {
        this.organizationDisId = organizationDisId;
    }

    public void setOrganizationDisSource(String organizationDisSource) {
        this.organizationDisSource = organizationDisSource;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setVisibility(Boolean visibility) {
        this.visibility = visibility;
    }

    public void setOrcidPutCode(String orcidPutCode) {
        this.orcidPutCode = orcidPutCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Funding)) {
            return false;
        }
        Funding other = (Funding)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$activityConfiguration = this.getActivityConfiguration();
        Long other$activityConfiguration = other.getActivityConfiguration();
        if (this$activityConfiguration == null ? other$activityConfiguration != null : !((Object)this$activityConfiguration).equals(other$activityConfiguration)) {
            return false;
        }
        Boolean this$synced = this.getSynced();
        Boolean other$synced = other.getSynced();
        if (this$synced == null ? other$synced != null : !((Object)this$synced).equals(other$synced)) {
            return false;
        }
        Boolean this$visibility = this.getVisibility();
        Boolean other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !((Object)this$visibility).equals(other$visibility)) {
            return false;
        }
        ResearcherProfile this$researcher = this.getResearcher();
        ResearcherProfile other$researcher = other.getResearcher();
        if (this$researcher == null ? other$researcher != null : !this$researcher.equals(other$researcher)) {
            return false;
        }
        LocalDate this$fromDate = this.getFromDate();
        LocalDate other$fromDate = other.getFromDate();
        if (this$fromDate == null ? other$fromDate != null : !((Object)this$fromDate).equals(other$fromDate)) {
            return false;
        }
        LocalDate this$toDate = this.getToDate();
        LocalDate other$toDate = other.getToDate();
        if (this$toDate == null ? other$toDate != null : !((Object)this$toDate).equals(other$toDate)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$fundingType = this.getFundingType();
        String other$fundingType = other.getFundingType();
        if (this$fundingType == null ? other$fundingType != null : !this$fundingType.equals(other$fundingType)) {
            return false;
        }
        String this$fundingIdType = this.getFundingIdType();
        String other$fundingIdType = other.getFundingIdType();
        if (this$fundingIdType == null ? other$fundingIdType != null : !this$fundingIdType.equals(other$fundingIdType)) {
            return false;
        }
        String this$fundingIdValue = this.getFundingIdValue();
        String other$fundingIdValue = other.getFundingIdValue();
        if (this$fundingIdValue == null ? other$fundingIdValue != null : !this$fundingIdValue.equals(other$fundingIdValue)) {
            return false;
        }
        String this$fundingRelationship = this.getFundingRelationship();
        String other$fundingRelationship = other.getFundingRelationship();
        if (this$fundingRelationship == null ? other$fundingRelationship != null : !this$fundingRelationship.equals(other$fundingRelationship)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$organizationName = this.getOrganizationName();
        String other$organizationName = other.getOrganizationName();
        if (this$organizationName == null ? other$organizationName != null : !this$organizationName.equals(other$organizationName)) {
            return false;
        }
        String this$organizationCity = this.getOrganizationCity();
        String other$organizationCity = other.getOrganizationCity();
        if (this$organizationCity == null ? other$organizationCity != null : !this$organizationCity.equals(other$organizationCity)) {
            return false;
        }
        String this$organizationCountry = this.getOrganizationCountry();
        String other$organizationCountry = other.getOrganizationCountry();
        if (this$organizationCountry == null ? other$organizationCountry != null : !this$organizationCountry.equals(other$organizationCountry)) {
            return false;
        }
        String this$organizationUrl = this.getOrganizationUrl();
        String other$organizationUrl = other.getOrganizationUrl();
        if (this$organizationUrl == null ? other$organizationUrl != null : !this$organizationUrl.equals(other$organizationUrl)) {
            return false;
        }
        String this$organizationDisId = this.getOrganizationDisId();
        String other$organizationDisId = other.getOrganizationDisId();
        if (this$organizationDisId == null ? other$organizationDisId != null : !this$organizationDisId.equals(other$organizationDisId)) {
            return false;
        }
        String this$organizationDisSource = this.getOrganizationDisSource();
        String other$organizationDisSource = other.getOrganizationDisSource();
        if (this$organizationDisSource == null ? other$organizationDisSource != null : !this$organizationDisSource.equals(other$organizationDisSource)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$orcidPutCode = this.getOrcidPutCode();
        String other$orcidPutCode = other.getOrcidPutCode();
        return !(this$orcidPutCode == null ? other$orcidPutCode != null : !this$orcidPutCode.equals(other$orcidPutCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Funding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $activityConfiguration = this.getActivityConfiguration();
        result = result * 59 + ($activityConfiguration == null ? 43 : ((Object)$activityConfiguration).hashCode());
        Boolean $synced = this.getSynced();
        result = result * 59 + ($synced == null ? 43 : ((Object)$synced).hashCode());
        Boolean $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : ((Object)$visibility).hashCode());
        ResearcherProfile $researcher = this.getResearcher();
        result = result * 59 + ($researcher == null ? 43 : $researcher.hashCode());
        LocalDate $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : ((Object)$fromDate).hashCode());
        LocalDate $toDate = this.getToDate();
        result = result * 59 + ($toDate == null ? 43 : ((Object)$toDate).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $fundingType = this.getFundingType();
        result = result * 59 + ($fundingType == null ? 43 : $fundingType.hashCode());
        String $fundingIdType = this.getFundingIdType();
        result = result * 59 + ($fundingIdType == null ? 43 : $fundingIdType.hashCode());
        String $fundingIdValue = this.getFundingIdValue();
        result = result * 59 + ($fundingIdValue == null ? 43 : $fundingIdValue.hashCode());
        String $fundingRelationship = this.getFundingRelationship();
        result = result * 59 + ($fundingRelationship == null ? 43 : $fundingRelationship.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $organizationName = this.getOrganizationName();
        result = result * 59 + ($organizationName == null ? 43 : $organizationName.hashCode());
        String $organizationCity = this.getOrganizationCity();
        result = result * 59 + ($organizationCity == null ? 43 : $organizationCity.hashCode());
        String $organizationCountry = this.getOrganizationCountry();
        result = result * 59 + ($organizationCountry == null ? 43 : $organizationCountry.hashCode());
        String $organizationUrl = this.getOrganizationUrl();
        result = result * 59 + ($organizationUrl == null ? 43 : $organizationUrl.hashCode());
        String $organizationDisId = this.getOrganizationDisId();
        result = result * 59 + ($organizationDisId == null ? 43 : $organizationDisId.hashCode());
        String $organizationDisSource = this.getOrganizationDisSource();
        result = result * 59 + ($organizationDisSource == null ? 43 : $organizationDisSource.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $orcidPutCode = this.getOrcidPutCode();
        result = result * 59 + ($orcidPutCode == null ? 43 : $orcidPutCode.hashCode());
        return result;
    }

    public String toString() {
        return "Funding(id=" + this.getId() + ", researcher=" + String.valueOf(this.getResearcher()) + ", activityConfiguration=" + this.getActivityConfiguration() + ", fromDate=" + String.valueOf(this.getFromDate()) + ", toDate=" + String.valueOf(this.getToDate()) + ", title=" + this.getTitle() + ", fundingType=" + this.getFundingType() + ", fundingIdType=" + this.getFundingIdType() + ", fundingIdValue=" + this.getFundingIdValue() + ", fundingRelationship=" + this.getFundingRelationship() + ", source=" + this.getSource() + ", synced=" + this.getSynced() + ", organizationName=" + this.getOrganizationName() + ", organizationCity=" + this.getOrganizationCity() + ", organizationCountry=" + this.getOrganizationCountry() + ", organizationUrl=" + this.getOrganizationUrl() + ", organizationDisId=" + this.getOrganizationDisId() + ", organizationDisSource=" + this.getOrganizationDisSource() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", visibility=" + this.getVisibility() + ", orcidPutCode=" + this.getOrcidPutCode() + ")";
    }

    public Funding(Long id, ResearcherProfile researcher, Long activityConfiguration, LocalDate fromDate, LocalDate toDate, String title, String fundingType, String fundingIdType, String fundingIdValue, String fundingRelationship, String source, Boolean synced, String organizationName, String organizationCity, String organizationCountry, String organizationUrl, String organizationDisId, String organizationDisSource, Instant createdAt, Instant updatedAt, Boolean visibility, String orcidPutCode) {
        this.id = id;
        this.researcher = researcher;
        this.activityConfiguration = activityConfiguration;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.title = title;
        this.fundingType = fundingType;
        this.fundingIdType = fundingIdType;
        this.fundingIdValue = fundingIdValue;
        this.fundingRelationship = fundingRelationship;
        this.source = source;
        this.synced = synced;
        this.organizationName = organizationName;
        this.organizationCity = organizationCity;
        this.organizationCountry = organizationCountry;
        this.organizationUrl = organizationUrl;
        this.organizationDisId = organizationDisId;
        this.organizationDisSource = organizationDisSource;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.visibility = visibility;
        this.orcidPutCode = orcidPutCode;
    }

    public Funding() {
    }
}

